#!/bin/bash
#-------------------------------------------------------------------------
#
#          DELL COMPUTER CORPORATION PROPRIETARY INFORMATION
#
#  This software is supplied under the terms of a license agreement or
#  nondisclosure agreement with Dell Computer Corporation and may not
#  be copied or disclosed except in accordance with the terms of that
#  agreement.
#
#  Copyright (c) 2020 Dell Computer Corp. All Rights Reserved.
#
#  Abstract/Purpose:
#  To list all the disks behind AHCI/SATA controller.
#------------------------------------------------------------------------

ism_enumereate_ahci_disk()
{
	#Remove the outfile if exists.
	if [ -f $1 ];
	then
		rm -f $1
	fi
	
	#Get the list of block device path available in os
	block_disk_list=`ls -lrtd /sys/block/* .* | awk '{print $NF " "}'`
	if [ $? != 0 ] || [ -z "$block_disk_list" ] ;
	then
		return 1
	fi
	
	#Get the list of ahci/sata controller device path available in os
	pci_ahci_controller_list=`lspci | grep -i -E 'ahci|sata' | awk {'printf $1 " "'}`
	if [ $? != 0 ] || [ -z "$pci_ahci_controller_list" ];
	then
		return 1
	fi

	#loop through the list of ahci/sata controller device path,and for each device path,
	#loop through the list of block device.
	#if disk path contains controller path , then  put the device path to out file
	for pci_iter in $pci_ahci_controller_list
	do
		pci_vendor=""
		pci_vendor=`cat /sys/bus/pci/devices/0000:$pci_iter/vendor`
		#echo $pci_vendor
		if [ $? != 0 ] || [ -z $pci_vendor ];
		then
			continue
		fi
		#Do not process if it's not under whilte list
		if [ $pci_vendor != "0x8086" ] && [ $pci_vendor != "0x1022" ] && [ $pci_vendor != "0x1002" ];
		then
			continue
		fi

		for disk_iter in $block_disk_list
		do
			#echo $disk_iter
			#echo $pci_iter
			echo $disk_iter | grep $pci_iter >> /dev/null
			if [ $? == 0 ];
			then
				disk_base_name=""
				disk_base_name=`basename $disk_iter`
				if [ $? != 0 ] || [ -z "$disk_base_name" ];
				then
					continue
				fi
				#finally driver should be ahci.
				udevadm info -q all -a /dev/$disk_base_name | grep -i -E 'DRIVERS=="ahci"' >> /dev/null
				if [ $? != 0 ];
				then
					continue
				fi
				printf "%s\n" $disk_base_name >> $1
			fi
		done
	done

	if [ ! -f $1 ];
	then
		echo "No AHCI controller is found"
		return 1
	fi
	return 0
}

if [ $# != 1 ];
then
	exit 1
fi

ism_enumereate_ahci_disk $1
exit $?

<<SAMPLEOUTPUT
[root@localhost Ranjit]# ls -lrtd /sys/block/* .* | awk '{print $NF " "}'
../devices/pci0000:00/0000:00:11.5/ata6/host5/target5:0:0/5:0:0:0/block/sdd
../devices/pci0000:00/0000:00:11.5/ata5/host4/target4:0:0/4:0:0:0/block/sdc
../devices/pci0000:00/0000:00:17.0/ata8/host7/target7:0:0/7:0:0:0/block/sdf
../devices/pci0000:00/0000:00:17.0/ata7/host6/target6:0:0/6:0:0:0/block/sde
../devices/pci0000:00/0000:00:17.0/ata10/host9/target9:0:0/9:0:0:0/block/sdh
../devices/pci0000:00/0000:00:11.5/ata3/host2/target2:0:0/2:0:0:0/block/sda
../devices/pci0000:00/0000:00:11.5/ata4/host3/target3:0:0/3:0:0:0/block/sdb
../devices/pci0000:00/0000:00:17.0/ata9/host8/target8:0:0/8:0:0:0/block/sdg
../devices/virtual/block/dm-0
../devices/virtual/block/dm-1
../devices/virtual/block/dm-3
../devices/virtual/block/dm-4
../devices/virtual/block/dm-2
../devices/virtual/block/dm-5
..
.

[root@localhost Ranjit]# lspci | grep -i -E 'ahci|sata' | awk {'printf $1 " "'}
00:11.5 00:17.0

[root@localhost ranjit]# cat /sys/bus/pci/devices/0000:00:11.5/vendor
0x8086
[root@localhost ranjit]# cat /sys/bus/pci/devices/0000:00:17.0/vendor
0x8086
[root@localhost ranjit]# cat /sys/bus/pci/devices/0000:86:00.0/vendor
0x1b4b
[root@localhost ranjit]#

[root@localhost Ranjit]# cat /opt/dell/srvadmin/iSM/etc/ini/ism_ahci_disks.txt
sdd
sdc
sda
sdb
sdf
sde
sdh
sdg


SAMPLEOUTPUT

