#!/bin/bash
#-------------------------------------------------------------------------
#
#          DELL COMPUTER CORPORATION PROPRIETARY INFORMATION
#
#  This software is supplied under the terms of a license agreement or
#  nondisclosure agreement with Dell Computer Corporation and may not
#  be copied or disclosed except in accordance with the terms of that
#  agreement.
#
#  Copyright (c) 2013 Dell Computer Corp. All Rights Reserved.
#
#  Abstract/Purpose:
#  iSM OSBMC over usb Configuration script
#  This script detects the DELL USBNIC interface and trying to configure
#  the same using IPv4 Network, it is assumed that the consumer is
#  passing an IPv4 iDRAC USBNIC address for this script to configure the
#  host interface.
#------------------------------------------------------------------------


usb_bus_no=0
usb_device_no=0
USB_BUS_BASE_DIR="/sys/bus/usb/devices/usb"
UNIQUE_DEVICE_ID="413c:a102"
REDHAT_RELEASE_FILE="/etc/redhat-release"
OS_RELEASE_FILE="/etc/os-release"

getUSBintfName()
{
usb_bus_no_str=`lsusb | grep -i $UNIQUE_DEVICE_ID | cut -d ":" -f 1 | cut -d " " -f 2`
usb_device_no_str=`lsusb | grep -i $UNIQUE_DEVICE_ID | cut -d ":" -f 1 | cut -d " " -f 4`
let usb_bus_no=$usb_bus_no+10#$usb_bus_no_str
let usb_device_no=$usb_device_no+10#$usb_device_no_str
#echo $usb_bus_no
#echo $usb_device_no
ethernet_interface_name_t=`find $USB_BUS_BASE_DIR$usb_bus_no/ | grep -i "net" | head -1`
#echo $ethernet_interface_name_t
cdir=`pwd`
cd $ethernet_interface_name_t
cd ..

cdir1=`pwd`
nodename=`echo $cdir1/net`
if [ -e $nodename ]
then
ethernet_interface_name=`ls $cdir1/net`
echo $ethernet_interface_name
cd $cdir
return 0
fi

ethernet_interface_name_t=`ls | grep -i "net"`
if [ $? -eq 0 ]
then

#echo $ethernet_interface_name_t
ethernet_interface_name=`echo $ethernet_interface_name_t | cut -d ":" -f 2`
echo $ethernet_interface_name
cd $cdir
return 0

fi

cd $cdir
return 1

}

AddIpToInterface()
{
interface_name=$1
ip_addr=$2
intf_retcode=1
if [ -f /sbin/ifconfig ]
then
/sbin/ifconfig $interface_name $ip_addr
if [ $? -eq 0 ]
then
intf_retcode=0
fi
fi 
return $intf_retcode
}

XenConfiguration()
{
verify_retcode=1
interface_name=$1
#rule for XenServer, remove guest bridge
if [ -f "$REDHAT_RELEASE_FILE" ]
then
cat $REDHAT_RELEASE_FILE | grep 'XenServer' > /dev/null
fi
if [ -f "$OS_RELEASE_FILE" ]
then
cat $OS_RELEASE_FILE | grep 'XenServer' > /dev/null
fi
if [ $? -eq 0 ]
then
	if_uuid=`xe pif-list device=$interface_name | grep uuid | grep -v network-uuid | cut -d ":" -f2 | cut -d " " -f2`
	if [ $if_uuid ]
	then
		xe pif-forget uuid=$if_uuid
		verify_retcode=0
	fi
fi
return $verify_retcode
}

VerifyDestinationIP()
{
verify_retcode=1
destination_ip=$1
interface_name=$2
#rule for XenServer, remove guest bridge
if [ -f "$REDHAT_RELEASE_FILE" ]
then
cat $REDHAT_RELEASE_FILE | grep XenServer > /dev/null
fi
if [ -f "$OS_RELEASE_FILE" ]
then
cat $OS_RELEASE_FILE | grep XenServer > /dev/null
fi
if [ $? -eq 0 ]
then
if_uuid=`xe pif-list device=$interface_name | grep uuid | grep -v network-uuid | cut -d ":" -f2 | cut -d " " -f2`
if [ $if_uuid ]
then
xe pif-forget uuid=$if_uuid
fi
fi #Xen rule ends

ping -c 5 -I $interface_name $destination_ip > /dev/null
if [ $? -eq 0 ]
then
	ping -c 5 $destination_ip > /dev/null
	if [ $? -eq 0 ]
	then
		verify_retcode=0
	fi
fi
return $verify_retcode
}

VerifyDestinationRoute()
{
verify_retcode=1
destination_ip=$1
source_ip=$2
echo "VerifyDestinationRoute called with $destination_ip and $source_ip"
ping_route=`ping -c 1 -R $destination_ip`
if [ $? -eq 0 ]
then
	echo $ping_route | grep $source_ip >/dev/null
	if [ $? -eq 0 ]
	then
		#route is fine
		verify_retcode=0
	fi
fi
return $verify_retcode
}

# Start of script..
retcode=1
command="$1"


DESTINATION_IP="$2"
lsusb | grep -i $UNIQUE_DEVICE_ID > /dev/null
if [ $? -ne 0 ]
then
	echo "Dell USBNIC Device is not exposed or OS driver for usbnic is not loaded.Exiting!!"
	exit $retcode
fi

interfacename=`getUSBintfName`

#this is to get usbnic interface name
if [ $command -eq 1 ]
then
	XenConfiguration $interfacename
	echo $interfacename
        if [ -f "$REDHAT_RELEASE_FILE" ]
        then 
        cat $REDHAT_RELEASE_FILE | grep '7.0\|CentOS' > /dev/null 
        fi
        if [ -f "$OS_RELEASE_FILE" ]
        then
        cat $OS_RELEASE_FILE | grep '7.0\|CentOS' > /dev/null
        fi 
	if [ $? -eq 0 ]
	then
		exit 0
	else
		exit 1
	fi
fi

echo "Dell USBNIC is exposed on interface $interfacename"

VerifyDestinationIP $DESTINATION_IP $interfacename
if [ $? -eq 0 ]
then
	#get the exiting address as ping is working
	/sbin/ifconfig $interfacename | grep "inet " | grep ":" 
	if [ $? -eq 0 ]
	then
		existing_source_ip=`/sbin/ifconfig $interfacename | grep "inet addr:" | cut -d ":" -f 2 | cut -d " " -f 1`
		echo "existing_source_ip = $existing_source_ip"
	else
		#rhel 7 case
		existing_source_ip=`ifconfig $interfacename | grep "inet " | cut -d "i" -f 2 | cut -d " " -f 2`
		echo "existing_source_ip = $existing_source_ip"
	fi
	
	VerifyDestinationRoute $DESTINATION_IP $existing_source_ip
	if [ $? -eq 0 ]
	then
		echo "USB Passthru is already working"
		retcode=0
	else
		echo "USB Passthru is working, but desired route not found"
		retcode=2
	fi
else
	echo "USB Passthru is not working, setting up"


	#Parse detination IP
	source_ip_octet1=`echo $DESTINATION_IP | cut -d "." -f 1`
	source_ip_octet2=`echo $DESTINATION_IP | cut -d "." -f 2`
	source_ip_octet3=`echo $DESTINATION_IP | cut -d "." -f 3`
	source_ip_octet4=`echo $DESTINATION_IP | cut -d "." -f 4`

	if [ $source_ip_octet4 -gt 253 ]
	then
		source_ip_octet4=$((source_ip_octet4-1))
	else
		source_ip_octet4=$((source_ip_octet4+1))
	fi

	SOURCE_IP=$source_ip_octet1.$source_ip_octet2.$source_ip_octet3.$source_ip_octet4

	echo DESTINATION_IP=$DESTINATION_IP
	echo SOURCE_IP=$SOURCE_IP



	AddIpToInterface $interfacename $SOURCE_IP
	if [ $? -eq 0 ]
	then
		VerifyDestinationIP $DESTINATION_IP $interfacename
		if [ $? -eq 0 ]
		then
			VerifyDestinationRoute $DESTINATION_IP $SOURCE_IP
			if [ $? -eq 0 ]
			then
				echo "setup complete - working"
				retcode=0
			else
				echo "USB Passthru is working, but desired route not found"
				retcode=2
			fi
		else
			echo "giveup!"
		fi

	fi #AddIpToInterface

fi #VerifyDestinationIP (first one)

exit $retcode

