#!/bin/bash

##
## function to unmount the DRACRW partition during uninstall of iSM
##
UnmountDRACRW()
{
	if [ -d /opt/dell/srvadmin/iSM/ismprogramdata/DRACRW ]; then
		umount /opt/dell/srvadmin/iSM/ismprogramdata/DRACRW
		rm -rf /opt/dell/srvadmin/iSM/ismprogramdata/DRACRW
	fi
}
##
## Execute proper command to delete an init script
##
UnInstallInitScript()
{
    INIT_SCRIPT_NAME="${1}"
    SYSCTL=`which systemctl 2> /dev/null`
    if [ -e /etc/init.d/${INIT_SCRIPT_NAME} ];
    then
    	/etc/init.d/${INIT_SCRIPT_NAME} stop
    	if [ -x /usr/lib/lsb/remove_initd ]; then
        	 /usr/lib/lsb/remove_initd /etc/init.d/${INIT_SCRIPT_NAME} >/dev/null 2>&1
    	elif [ -x /sbin/chkconfig ]; then
        	/sbin/chkconfig --del ${INIT_SCRIPT_NAME}
    	fi
    else
        if [ ! -z $SYSCTL ];then    
	        $SYSCTL stop ${INIT_SCRIPT_NAME}
	        $SYSCTL disable ${INIT_SCRIPT_NAME}
	        $SYSCTL daemon-reload
	        #semodule -r ismpol	
        fi
    fi	
    return 0
}

UnInstallInitScript  dcismeng 
UnmountDRACRW

