#!/bin/bash

##
## Execute proper command to install an init script
##
InstallInitScript()
{
	INIT_SCRIPT_NAME="${1}"
    SYSCTL=`which systemctl 2> /dev/null`

	#Ubuntu service files are at /lib/systemd/system/ location
	if [ -f /usr/lib/systemd/system/${INIT_SCRIPT_NAME}.service ] || [ -f /lib/systemd/system/${INIT_SCRIPT_NAME}.service ];
	then
		#The below code added for upgrade on RHEL 7 
		if [ -f /etc/systemd/system/${INIT_SCRIPT_NAME}.service ] && [ ! -z $SYSCTL ];
		then
			$SYSCTL disable ${INIT_SCRIPT_NAME}
			mv /etc/systemd/system/${INIT_SCRIPT_NAME}.service /etc/systemd/system/${INIT_SCRIPT_NAME}.service.bak
		fi	
		# this is for the system based on systemd
        if [ ! -z $SYSCTL ]; then
		    $SYSCTL daemon-reload
		    $SYSCTL enable ${INIT_SCRIPT_NAME}
		    $SYSCTL daemon-reload
        fi
		#The below code runs for upgrade on RHEL 7
		if [ -f /etc/systemd/system/${INIT_SCRIPT_NAME}.service.bak ];
		then	
			mv /etc/systemd/system/${INIT_SCRIPT_NAME}.service.bak /etc/systemd/system/${INIT_SCRIPT_NAME}.service
		fi
	elif [ -x /sbin/chkconfig ];
	then
		# this is a Red Hat type install
		/sbin/chkconfig --add ${INIT_SCRIPT_NAME}  >/dev/null 2>&1

	# check for lsb install
	elif [ -x /usr/lib/lsb/install_initd ];
	then
		# this is an lsb install
		/usr/lib/lsb/install_initd /etc/init.d/${INIT_SCRIPT_NAME} >/dev/null 2>&1
	fi
	return 0
}


InstallInitScript  dcismeng 

exit 0
