<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:output method="xml" />
<xsl:strip-space elements="*"/>



<xsl:template match="/osda">
	<osda>
		   <xsl:choose>
		   			<xsl:when test="//SMStatus = 0">
						<xsl:call-template name="Process" />
					</xsl:when>
					<xsl:when test = "//SMStatus &lt; 1">
						<xsl:call-template name="NoSource" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="NoSource" />
					</xsl:otherwise>
			</xsl:choose>
	</osda>
</xsl:template>

<xsl:template name="NoSource">
  <SMStatus>-1</SMStatus>
</xsl:template>

<xsl:template name="Process">
   <SYSTEMSUMMARY>
	   <xsl:call-template name="Ver"/>
	   <xsl:call-template name="Uname"/>
   </SYSTEMSUMMARY>
<SMStatus>0</SMStatus>
	
</xsl:template>

<xsl:template name="Ver">
    <xsl:for-each select=" Label">
		<xsl:if test="@section= 'osversion' ">

				  <xsl:variable name="Fld1" select="normalize-space(.)"/> 
				  <xsl:if test="string-length(@hint) &gt; 0">
						<OSNAME displayname="Operating System Name" type="string" >
						<xsl:value-of select="$Fld1"/>
						<!-- <xsl:value-of select="substring-before(substring-after(node(),'to'),'-') "/> -->
						</OSNAME>
				</xsl:if>
		</xsl:if>
		<xsl:if test="@section ='uname'">
				<xsl:variable name="Fld1" select="normalize-space(substring-before(.,' '))"/>
			   <xsl:variable name="Fld2" select="normalize-space(substring-after(.,' '))"/>
			   <xsl:variable name="Fld3" select="substring-after($Fld2,' ')"/>
			   
				<xsl:if test="$Fld1">
				<System_Name displayname="System Name" type="string"><xsl:value-of select="substring-before($Fld2,' ')"/>
				</System_Name>
					<Version displayname="Version"  type="string"><xsl:value-of select="$Fld3"/>
					</Version>
				</xsl:if>
		</xsl:if>
		
		<xsl:if test="@section='proc/mounts'">
               <xsl:variable name="Fld1" select="normalize-space(substring-before(.,' '))"/>
			   <xsl:variable name="Fld2" select="normalize-space(substring-after(.,' '))"/>
			   <xsl:variable name="Fld3" select="substring-after($Fld2,' ')"/>
			   <xsl:variable name="Fld4" select="substring-after($Fld3,' ')"/>
			   <xsl:variable name="Fld5" select="substring-after($Fld4,' ')"/>
			   <xsl:variable name="Fld6" select="substring-after($Fld5,' ')"/>
		   
			   <MOUNTS >
				   <Device  displayname="Device Name" type="string" ><xsl:value-of select="$Fld1"/></Device>
				   <Mount_Point displayname="Mount Point" type="string" ><xsl:value-of select="substring-before($Fld3,' ')"/></Mount_Point>
				   <Type  displayname="Type" type="string"><xsl:value-of select="substring-before($Fld5,' ')"/></Type>
				   <Flags displayname="Flags" type="string" ><xsl:value-of select="$Fld6"/> </Flags>
			   </MOUNTS >
		</xsl:if>
        <xsl:if test="@section ='install-date'">
            <xsl:variable name="Fld1" select="normalize-space(substring-before(.,'Build'))"/>
            <xsl:variable name="Fld2" select="substring-after($Fld1,'Date: ')"/>
            <xsl:if test="string-length(@hint) &gt; 0">
                <InstallDate displayname="Install Date" type="string" >
                    <xsl:value-of select="$Fld2"/>
                    <!-- <xsl:value-of select="substring-before(substring-after(node(),'to'),'-') "/> -->
                </InstallDate>
            </xsl:if>
        </xsl:if>
	</xsl:for-each>
</xsl:template>



<xsl:template name="Uname">
</xsl:template>





		

</xsl:stylesheet>
