<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:output method="xml" />
<xsl:strip-space elements="*"/>

<xsl:template match="/osda">
	<osda>
					<xsl:call-template name="Process" />
	</osda>
</xsl:template>

<xsl:template name="Process">

   <xsl:call-template name="Service"/>

	<SMStatus>0</SMStatus>
</xsl:template>


<xsl:template name="Service">
    <xsl:for-each select=" Label[@hint = 'ValidXMLService'] ">
			<xsl:variable name="Fld1" select="substring-after(node(),' ')"/>
			<xsl:variable name="Fld2" select="substring-after($Fld1,',')"/>
			<xsl:variable name="Fld3" select="substring-after($Fld2,' ')"/>
			
			<SERVICE>
			       <Name displayname="Service" type="string" ><xsl:value-of select="substring-before($Fld1,',')"/>
			       </Name>
			       <State displayname="State" type="string" ><xsl:value-of select="$Fld2"/></State>
		</SERVICE>
    </xsl:for-each>
</xsl:template>

</xsl:stylesheet>
