<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:output method="xml" />
<xsl:strip-space elements="*"/>

<!-- these are needed because 1.0 doesn't support upper-case() function; use translate() instead-->
<xsl:variable name="lowercase" select="'abcdefghijklmnopqrstuvwxyz'"/>
<xsl:variable name="uppercase" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'"/>

<xsl:template match="/osda">
	<osda>
		   <xsl:choose>
		   			<xsl:when test="//SMStatus = 0">
						<xsl:call-template name="Process" />
					</xsl:when>
					<xsl:when test = "//SMStatus &lt; 1">
						<xsl:call-template name="NoSource" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="NoSource" />
					</xsl:otherwise>
			</xsl:choose>
	</osda>
</xsl:template>

<xsl:template name="NoSource">
  <SMStatus>-1</SMStatus>
</xsl:template>

<xsl:template name="Process">

    <!-- THIS SHOULD SELECT FROM ONLY THE FIRST ROW SO WE GET HEADER INFO-->
    <xsl:variable name="Head1" select="substring-before(Label,' ')"/>
	<xsl:variable name="Head2" select="normalize-space(substring-after(Label,' '))"/>
	<xsl:variable name="Head3" select="substring-after($Head2,' ')"/>
	<xsl:variable name="Head4" select="substring-after($Head3,' ')"/>
	<xsl:variable name="Head5" select="substring-after($Head4,' ')"/>
	<xsl:variable name="Head6" select="substring-after($Head5,' ')"/>
	<xsl:variable name="Head7" select="substring-after($Head6,' ')"/>
	<xsl:variable name="Head8" select="substring-after($Head7,' ')"/>
	<xsl:variable name="Head9" select="substring-after($Head8,' ')"/>
	<xsl:variable name="Head10" select="substring-after($Head9,' ')"/>
	<xsl:variable name="Head11" select="substring-after($Head10,' ')"/>
	
    <!-- Now pass in the  HEADER INFO to be asssigned to displayname-->
   <xsl:call-template name="Processes">
	   <xsl:with-param name="Head1" select="$Head1"/>
	   <xsl:with-param name="Head2" select="$Head2"/>
	   <xsl:with-param name="Head3" select="$Head3"/>
	   <xsl:with-param name="Head4" select="$Head4"/>
	   <xsl:with-param name="Head5" select="$Head5"/>
	   <xsl:with-param name="Head6" select="$Head6"/>
	   <xsl:with-param name="Head7" select="$Head7"/>
	   <xsl:with-param name="Head8" select="$Head8"/>
	   <xsl:with-param name="Head9" select="$Head9"/>
	   <xsl:with-param name="Head10" select="$Head10"/>
	   <xsl:with-param name="Head11" select="$Head11"/>
   </xsl:call-template>

	<SMStatus>0</SMStatus>
</xsl:template>

<xsl:template name="Processes">
<!-- we can use the same names for the parameters here because we can not SEE the upper level variables
      it is also important to name them the same as the calling "with-param" statement.
-->
	<xsl:param name="Head1" />
	<xsl:param name="Head2" />
	<xsl:param name="Head3" />
	<xsl:param name="Head4" />
	<xsl:param name="Head5" />
	<xsl:param name="Head6" />
	<xsl:param name="Head7" />
	<xsl:param name="Head8" />
	<xsl:param name="Head9" />
	<xsl:param name="Head10" />
	<xsl:param name="Head11" />
    <xsl:for-each select=" Label">
		<xsl:if test="position() &gt; 1">
		
			   <xsl:variable name="Fld1" select="normalize-space(substring-before(.,' '))"/>
			   <xsl:variable name="Fld2" select="normalize-space(substring-after(.,' '))"/>
			   <xsl:variable name="Fld3" select="substring-after($Fld2,' ')"/>
			   <xsl:variable name="Fld4" select="substring-after($Fld3,' ')"/>
			   <xsl:variable name="Fld5" select="substring-after($Fld4,' ')"/>
			   <xsl:variable name="Fld6" select="substring-after($Fld5,' ')"/>
			   <xsl:variable name="Fld7" select="substring-after($Fld6,' ')"/>
			   <xsl:variable name="Fld8" select="substring-after($Fld7,' ')"/>
			   <xsl:variable name="Fld9" select="substring-after($Fld8,' ')"/>
			   <xsl:variable name="Fld10" select="substring-after($Fld9,' ')"/>
			   <xsl:variable name="Fld11" select="substring-after($Fld10,' ')"/>
			   
			<Processes>
				<Name displayname="{$Head11}" type="string" >
				<xsl:attribute name="SNAME"><xsl:value-of select="translate($Fld11,$lowercase,$uppercase)"/></xsl:attribute>
				<xsl:value-of select="$Fld11"/>
				</Name>
				<ID displayname="{substring-before($Head2,' ')}" type="uint" ><xsl:value-of select="substring-before($Fld2,' ')"/></ID>
				<PercentCPU displayname="{substring-before($Head3,' ')}" type="string"><xsl:value-of select="substring-before($Fld3,' ')"/></PercentCPU>
				<PercentMem_Usage displayname="{substring-before($Head4,' ')}" type="string"><xsl:value-of select="substring-before($Fld4,' ')"/></PercentMem_Usage>
				<Mem_Usage displayname="{substring-before($Head6,' ')}" type="string"  ><xsl:value-of select="substring-before($Fld5,' ')"/></Mem_Usage>
				<VM_Size displayname="{substring-before($Head5,' ')}" type="unit64"><xsl:value-of select="substring-before($Fld6,' ')"/></VM_Size>
				<Paged_Pool displayname="Paged Pool" type="int">0</Paged_Pool>
				<NP_Pool displayname="NP Pool" type="int">0</NP_Pool>
				<Page_Faults displayname="Page Faults" type="int" >0</Page_Faults>
				<CPU_Time displayname="{substring-before($Head10,' ')}" type="string"><xsl:value-of select="substring-before($Fld10,' ')"/></CPU_Time>
				<Priority displayname="Priority" type="string"></Priority>
				<Threads displayname="Threads" type="int" >0</Threads>
				<Handles displayname="Handles" type="int">0</Handles>
				<Started displayname="{substring-before($Head9,' ')}" type="string"><xsl:value-of select="substring-before($Fld9,' ')"/></Started>
				<Path displayname="{$Head11}" type="string"><xsl:value-of select="$Fld11"/></Path>
				<GDI_Objects displayname="GUID Objects" type="int">0</GDI_Objects>
				<User_Objects displayname="User Objects" type="int">0</User_Objects>
				<IO_Reads displayname="IO Reads" type="int">0</IO_Reads>
				<IO_Writes displayname="IO Writes" type="int">0</IO_Writes>
				<IO_Other displayname="IO Other" type="int">0</IO_Other>
				<Read_bytes displayname="Read Bytes" type="int">0</Read_bytes>
				<Write_bytes displayname="Write Bytes" type="int">0</Write_bytes>
				<Other_bytes displayname="Other Bytes" type="int">0</Other_bytes>
				<Status displayname="{substring-before($Head8,' ')}" type="string" ><xsl:value-of select="substring-before($Fld8,' ')"/></Status>
				<User displayname="{$Head1}" type="stirng" ><xsl:value-of select="$Fld1"/></User>
				<TTY displayname="{substring-before($Head7,' ')}"><xsl:value-of select="substring-before($Fld7,' ')"/></TTY>
		</Processes>

		</xsl:if>
    </xsl:for-each>
</xsl:template>


</xsl:stylesheet>
