<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:output method="xml" />
<xsl:strip-space elements="*"/>



<xsl:template match="/osda">
	<osda>
		   <xsl:choose>
		   			<xsl:when test="//SMStatus = 0">
						<xsl:call-template name="Process" />
					</xsl:when>
					<xsl:when test = "//SMStatus &lt; 1">
						<xsl:call-template name="NoSource" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="NoSource" />
					</xsl:otherwise>
			</xsl:choose>
	</osda>
</xsl:template>

<xsl:template name="NoSource">
  <SMStatus>-1</SMStatus>
</xsl:template>

<xsl:template name="Process">
   <xsl:call-template name="Env"/>
<SMStatus>0</SMStatus>
	
</xsl:template>

<xsl:template name="Env">
    <xsl:for-each select=" Label">
     <ENVVAR>
        <Variable displayname="Variable" type="string"><xsl:value-of select="substring-before(.,'=')"/>
        </Variable>
        <Variable_Value displayname="Variable Value" type="string" ><xsl:value-of select="substring-after(.,'=')"/>
        </Variable_Value>
     </ENVVAR>
    </xsl:for-each>
</xsl:template>


</xsl:stylesheet>
