<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:output method="xml" />
<xsl:strip-space elements="*"/>



<xsl:template match="/osda">
	<osda>
		   <xsl:choose>
		   			<xsl:when test="//SMStatus = 0">
						<xsl:call-template name="Process" />
					</xsl:when>
					<xsl:when test = "//SMStatus &lt; 1">
						<xsl:call-template name="NoSource" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="NoSource" />
					</xsl:otherwise>
			</xsl:choose>
	</osda>
</xsl:template>

<xsl:template name="NoSource">
  <SMStatus>-1</SMStatus>
</xsl:template>

<xsl:template name="Process">
   <xsl:call-template name="Log"/>
<SMStatus>0</SMStatus>
	
</xsl:template>

<xsl:template name="Log">
    <xsl:for-each select=" Label">
				<xsl:variable name="Fld1" select="normalize-space(substring-before(.,' '))"/>
			   <xsl:variable name="Fld2" select="normalize-space(substring-after(.,' '))"/>
			   <xsl:variable name="Fld3" select="substring-after($Fld2,' ')"/>
			   <xsl:variable name="Fld4" select="substring-after($Fld3,' ')"/>
			   <xsl:variable name="Fld5" select="substring-after($Fld4,' ')"/>
			   <xsl:variable name="Fld6" select="substring-after($Fld5,' ')"/>

    
		 <MESSAGES>
		 <EntryType displayname="EntryID" type="string">
		   <xsl:choose>
						<xsl:when test="contains($Fld5,'WARN') ">
							<xsl:value-of select="string('Warning')"/>
						</xsl:when>
							<xsl:when test="contains($Fld5,'error') ">
								<xsl:value-of select="string('Error')"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="string('Information')"/>
							</xsl:otherwise>
				</xsl:choose>
		 </EntryType>
			<EntryID displayname="EntryID" type="string"><xsl:value-of select="@lineno"/></EntryID>
			<Time displayname="Time" type="string">
				<xsl:value-of select="$Fld1"/>
				<xsl:value-of select="string(' ')"/>
				<xsl:value-of select="substring-before($Fld2,' ')"/>
				<xsl:value-of select="string(' ')"/>
				<xsl:value-of select="substring-before($Fld3,' ')"/>
			</Time>
			<Source displayname="Source" type="string" ><xsl:value-of select="substring-before($Fld5,' ')"/> </Source>
			<Message><xsl:value-of select="$Fld6"/>
			</Message>
		 </MESSAGES>
    </xsl:for-each>
</xsl:template>


</xsl:stylesheet>
