<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:output method="xml" />
<xsl:strip-space elements="*"/>



<xsl:template match="/osda">
	<osda>
		   <xsl:choose>
		   			<xsl:when test="//SMStatus = 0">
						<xsl:call-template name="Process" />
					</xsl:when>
					<xsl:when test = "//SMStatus &lt; 1">
						<xsl:call-template name="NoSource" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="NoSource" />
					</xsl:otherwise>
			</xsl:choose>
	</osda>
</xsl:template>

<xsl:template name="NoSource">
  <SMStatus>-1</SMStatus>
</xsl:template>

<xsl:template name="Process">

   <xsl:call-template name="Ports"/>

<SMStatus>0</SMStatus>
	
</xsl:template>

<xsl:template name="Ports">
    <xsl:for-each select=" Label">
		<xsl:if test="contains(node(),'-')">
		      <IOPORT>
					<Address_Range displayname="Address_Range" type="uint64" ><xsl:value-of select="@hint"/>
					</Address_Range>
					<Device displayname="Device" type="string" ><xsl:value-of select="normalize-space(substring-after(node(),':'))"/>
					</Device>
					<Status displayname="Status" type="string" >OK</Status>
				</IOPORT>
		</xsl:if>
    </xsl:for-each>
</xsl:template>


</xsl:stylesheet>
