<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:output method="xml" />
<xsl:strip-space elements="*"/>

<xsl:template match="/osda">
	<osda>
		   <xsl:choose>
		   			<xsl:when test="//SMStatus = 0">
						<xsl:call-template name="Process" />
					</xsl:when>
					<xsl:when test = "//SMStatus &lt; 1">
						<xsl:call-template name="NoSource" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="NoSource" />
					</xsl:otherwise>
			</xsl:choose>
	</osda>
</xsl:template>

<xsl:template name="NoSource">
  <SMStatus>-1</SMStatus>
</xsl:template>

<xsl:template name="Process">

   <xsl:call-template name="Memory"/>

   <xsl:call-template name="Base"/>
   
   <!-- The Following logic only works when there are 5 or less attached devices -->
    <xsl:if test="//Label/@hint = 'proc/scsi/scsi' ">
             <xsl:variable name="Start"><xsl:value-of select ="Label[contains(@hint,'Attached') ]/@lineno"/></xsl:variable>
             <xsl:variable name="Stop"><xsl:value-of select="Label[contains(@section, 'Type')]/@lineno "/></xsl:variable> 

	       <xsl:choose>
	               <xsl:when test="number($Stop) - number($Start) = 4">
	                  <ATTACHEDSCSI>
					   <xsl:call-template name="SCSI">
							<xsl:with-param name="Begin"><xsl:value-of select="$Start"/></xsl:with-param>
							<xsl:with-param name="End"><xsl:value-of select="$Stop"/></xsl:with-param>
					   </xsl:call-template>
					</ATTACHEDSCSI>
					</xsl:when>
					
	               <xsl:when test="number($Stop) - number($Start) = 7">
	                  <ATTACHEDSCSI>
						   <xsl:call-template name="SCSI">
								<xsl:with-param name="Begin"><xsl:value-of select="$Start+1"/></xsl:with-param>
								<xsl:with-param name="End"><xsl:value-of select="$Start+4"/></xsl:with-param>
						   </xsl:call-template>
						</ATTACHEDSCSI>
	                  <ATTACHEDSCSI>
					   <xsl:call-template name="SCSI">
							<xsl:with-param name="Begin"><xsl:value-of select="$Start+4"/></xsl:with-param>
							<xsl:with-param name="End"><xsl:value-of select="$Stop"/></xsl:with-param>
					   </xsl:call-template>
					</ATTACHEDSCSI>
				</xsl:when>
				
	               <xsl:when test="number($Stop) - number($Start) = 10">
	                  <ATTACHEDSCSI>
					   <xsl:call-template name="SCSI">
							<xsl:with-param name="Begin"><xsl:value-of select="$Start+1"/></xsl:with-param>
							<xsl:with-param name="End"><xsl:value-of select="$Start+4"/></xsl:with-param>
					   </xsl:call-template>
					</ATTACHEDSCSI>
	                  <ATTACHEDSCSI>
					   <xsl:call-template name="SCSI">
							<xsl:with-param name="Begin"><xsl:value-of select="$Start+4"/></xsl:with-param>
							<xsl:with-param name="End"><xsl:value-of select="$Start+7"/></xsl:with-param>
					   </xsl:call-template>
					</ATTACHEDSCSI>
	                  <ATTACHEDSCSI>
					   <xsl:call-template name="SCSI">
							<xsl:with-param name="Begin"><xsl:value-of select="$Start+7"/></xsl:with-param>
							<xsl:with-param name="End"><xsl:value-of select="$Stop"/></xsl:with-param>
					   </xsl:call-template>
					</ATTACHEDSCSI>
				</xsl:when>
				
	               <xsl:when test="number($Stop) - number($Start) = 13">
	                  <ATTACHEDSCSI>
					   <xsl:call-template name="SCSI">
							<xsl:with-param name="Begin"><xsl:value-of select="$Start+1"/></xsl:with-param>
							<xsl:with-param name="End"><xsl:value-of select="$Start+4"/></xsl:with-param>
					   </xsl:call-template>
					</ATTACHEDSCSI>
	                  <ATTACHEDSCSI>
					   <xsl:call-template name="SCSI">
							<xsl:with-param name="Begin"><xsl:value-of select="$Start+4"/></xsl:with-param>
							<xsl:with-param name="End"><xsl:value-of select="$Start+7"/></xsl:with-param>
					   </xsl:call-template>
					</ATTACHEDSCSI>
	                  <ATTACHEDSCSI>
					   <xsl:call-template name="SCSI">
							<xsl:with-param name="Begin"><xsl:value-of select="$Start+7"/></xsl:with-param>
							<xsl:with-param name="End"><xsl:value-of select="$Start+10"/></xsl:with-param>
					   </xsl:call-template>
					</ATTACHEDSCSI>
	                  <ATTACHEDSCSI>
					   <xsl:call-template name="SCSI">
							<xsl:with-param name="Begin"><xsl:value-of select="$Start+10"/></xsl:with-param>
							<xsl:with-param name="End"><xsl:value-of select="$Stop"/></xsl:with-param>
					   </xsl:call-template>
					</ATTACHEDSCSI>
				</xsl:when>

	               <xsl:when test="number($Stop) - number($Start) = 16">
	                  <ATTACHEDSCSI>
					   <xsl:call-template name="SCSI">
							<xsl:with-param name="Begin"><xsl:value-of select="$Start+1"/></xsl:with-param>
							<xsl:with-param name="End"><xsl:value-of select="$Start+4"/></xsl:with-param>
					   </xsl:call-template>
					</ATTACHEDSCSI>
	                  <ATTACHEDSCSI>
					   <xsl:call-template name="SCSI">
							<xsl:with-param name="Begin"><xsl:value-of select="$Start+4"/></xsl:with-param>
							<xsl:with-param name="End"><xsl:value-of select="$Start+7"/></xsl:with-param>
					   </xsl:call-template>
					</ATTACHEDSCSI>
	                  <ATTACHEDSCSI>
					   <xsl:call-template name="SCSI">
							<xsl:with-param name="Begin"><xsl:value-of select="$Start+7"/></xsl:with-param>
							<xsl:with-param name="End"><xsl:value-of select="$Start+10"/></xsl:with-param>
					   </xsl:call-template>
					</ATTACHEDSCSI>
	                  <ATTACHEDSCSI>
					   <xsl:call-template name="SCSI">
							<xsl:with-param name="Begin"><xsl:value-of select="$Start+10"/></xsl:with-param>
							<xsl:with-param name="End"><xsl:value-of select="$Start+13"/></xsl:with-param>
					   </xsl:call-template>
					</ATTACHEDSCSI>
	                  <ATTACHEDSCSI>
					   <xsl:call-template name="SCSI">
							<xsl:with-param name="Begin"><xsl:value-of select="$Start+13"/></xsl:with-param>
							<xsl:with-param name="End"><xsl:value-of select="$Start+16"/></xsl:with-param>
					   </xsl:call-template>
					</ATTACHEDSCSI>
				</xsl:when>
				
	       </xsl:choose>			
	</xsl:if>
  <SMStatus>0</SMStatus>
</xsl:template>

<xsl:template name="Memory">
    <xsl:for-each select=" Label[position() &lt; 7] ">
			   <xsl:variable name="Fld1" select="normalize-space(substring-after(.,':'))"/>
			   <xsl:variable name="Fld2" select="substring-after($Fld1,' ')"/>
			   <xsl:variable name="Fld3" select="substring-after($Fld2,' ')"/>
			   <xsl:variable name="Fld4" select="substring-after($Fld3,' ')"/>
			   <xsl:variable name="Fld5" select="substring-after($Fld4,' ')"/>
			   <xsl:variable name="Fld6" select="substring-after($Fld5,' ')"/>
			   
			   <xsl:variable name="Total" select="substring-before($Fld1,' ')"/>
			   <xsl:variable name="Used" select="substring-before($Fld2,' ')"/>
			   <xsl:variable name="Free"  select="substring-before($Fld3,' ')"/>
			   <xsl:variable name="Shared" select="substring-before($Fld4,' ')"/>
			   <xsl:variable name="Buffers"  select="substring-before($Fld5,' ')"/>
			   <xsl:variable name="Cached"  select="$Fld6"/>

			<xsl:choose>
				<xsl:when test="@hint = 'Mem:' ">
					<MEMSTAT name="Memory">
						<ITEM displayname="Total" type="string" unit="KB" ><xsl:value-of select="$Total"/></ITEM>
						<ITEM displayname="Used" type="string" unit="KB" ><xsl:value-of select="$Used"/></ITEM>
						<ITEM displayname="Free" type="string" unit="KB" ><xsl:value-of select="$Free"/></ITEM>
						<ITEM displayname="Shared" type="string"  ><xsl:value-of select="$Shared"/></ITEM>
						<ITEM displayname="Buffers" type="string" unit="KB" ><xsl:value-of select="$Buffers"/></ITEM>
						<ITEM displayname="Cached" type="string" unit="KB" ><xsl:value-of select="$Cached"/></ITEM>
					</MEMSTAT>
				</xsl:when>
				<xsl:when test="@hint = '-/+' ">
					<MEMSTAT name="buffers_cache">
						<ITEM displayname="Total" type="string" unit="KB" ><xsl:value-of select="$Total"/></ITEM>
						<ITEM displayname="Used" type="string" unit="KB" ><xsl:value-of select="substring-after($Fld1,' ')"/></ITEM>
					</MEMSTAT>
				</xsl:when>
				<xsl:when test="@hint = 'Swap:' ">
					<MEMSTAT name="Swap">
						<ITEM displayname="Total" type="string" unit="KB" ><xsl:value-of select="$Total"/></ITEM>
						<ITEM displayname="Used" type="string" unit="KB" ><xsl:value-of select="$Used"/></ITEM>
						<ITEM displayname="Free" type="string" unit="KB" ><xsl:value-of select="substring-after($Fld2,' ')"/></ITEM>
					</MEMSTAT>
				</xsl:when>
			</xsl:choose>
    </xsl:for-each>
</xsl:template>

<xsl:template name="Base">
    <xsl:for-each select="Label">
			   <xsl:if test="@section = 'free' ">
			        <!-- We want ot skip over the initial 7 lines of text that contains Uptime info and Memory use-->
			         <xsl:if test="position() &gt; 7">
							<STORAGEBASE>
			                   <xsl:variable name="Fld1" select="substring-after(normalize-space(.),' ')"/>
			                   <xsl:variable name="Fld2" select="substring-after($Fld1,' ')"/>
			                   <xsl:variable name="Fld3" select="substring-after($Fld2,' ')"/>
			                   <xsl:variable name="Fld4" select="substring-after($Fld3,' ')"/>
			                   <xsl:variable name="Fld5" select="substring-after($Fld4,' ')"/>
			                  
			                   <xsl:variable name="FileSystem" select="substring-before(normalize-space(.),' ')"/>
			                   <xsl:variable name="Size" select="substring-before($Fld1,' ')"/>
			                   <xsl:variable name="Used" select="substring-before($Fld2,' ')"/>
			                   <xsl:variable name="FreeSpace" select="substring-before($Fld3,' ')"/>
			                   <xsl:variable name="PercentUsed" select="substring-before($Fld4,' ')"/>
			                   <xsl:variable name="Volume" select="$Fld5"/>
			                   
			                   <Drive  displayname="Drive" type="string"/>
			                   <Description  displayname="Description" type="string"><xsl:value-of select="$FileSystem"/></Description>
			                   <Compressed  displayname="Compressed" type="string"/>
							   <FileSystem  displayname="FileSystem" type="string" ><xsl:value-of select="$FileSystem"/> </FileSystem>
							   <Size  displayname="Size" type="string" unit="KB" ><xsl:value-of select="$Size"/></Size>
							   <FreeSpace  displayname="FreeSpace" type="string" unit="KB" ><xsl:value-of select="$FreeSpace"/></FreeSpace>
							   <Used  displayname="UsedSpace" type="string" unit="KB" ><xsl:value-of select="$Used"/></Used>
							   <PercentUsed  displayname="Percent UsedSpace" type="string"><xsl:value-of select="$PercentUsed"/></PercentUsed>
							   <VolumeName  displayname="VolumeName" type="string"><xsl:value-of select="$Volume"/></VolumeName>
							   <VolumeSerial displayname="VolumeSerial" type="string"/>
							</STORAGEBASE>
					</xsl:if>		
			   </xsl:if>
    </xsl:for-each>
    
</xsl:template>

<xsl:template name="SCSI">
   <xsl:param name="Begin"></xsl:param>
   <xsl:param name="End"></xsl:param>
   
    <xsl:for-each select="Label[ @lineno &gt;= $Begin and @lineno &lt; $End ] ">
    
                   <xsl:variable name="Fld1" select="substring-before(normalize-space(.),': ')"/>
                   <xsl:variable name="Fld2" select="substring-after(normalize-space(.),': ')"/>
                   <xsl:variable name="Fld3" select="substring-after($Fld2, ' ')"/>
                   <xsl:variable name="Fld4" select="normalize-space(substring-after($Fld3,':'))"/>
                   <xsl:variable name="Fld5" select="substring-after($Fld4,' ')"/>
                   <xsl:variable name="Fld6" select="normalize-space(substring-after($Fld5,':'))"/>
                   <xsl:variable name="Fld7" select="substring-after($Fld6,' ')"/>
                   <xsl:variable name="Fld8" select="normalize-space(substring-after($Fld7,':'))"/>
                  
                   <xsl:variable name="Host" select="substring-before($Fld2,' ')"/>
                   <xsl:variable name="Channel" select="substring-before($Fld4,' ')"/>
                   <xsl:variable name="SC_ID" select="substring-before($Fld6,' ')"/>
                   <xsl:variable name="LUN" select="$Fld8"/>
			                   
                   <xsl:choose>
				<xsl:when test="@hint = 'Host:'">
				  <ATTACHEDHOST>
				     <xsl:call-template name="Scsi_Host">
						 <xsl:with-param name="Host" select="$Host"/>
						 <xsl:with-param name="Channel" select="$Channel"/>
						 <xsl:with-param name="SC_ID" select="$SC_ID"/>
						 <xsl:with-param name="LUN" select="$LUN"/>
				     </xsl:call-template>
				     </ATTACHEDHOST>
				</xsl:when>
				<xsl:when test="@hint = 'Vendor:'">
				   <ATTACHEDVENDOR>
				     <xsl:call-template name="Scsi_Vendor">
						 <xsl:with-param name="Vendor" select="$Host"/>
						 <xsl:with-param name="Model" select="substring-before($Fld4,'Rev')"/>
						 <xsl:with-param name="Revision" select="$Fld6"/>
				     </xsl:call-template>
				     </ATTACHEDVENDOR>
				</xsl:when>
				<xsl:when test="@hint = 'Type:'">
				    <ATTACHEDTYPE>
				     <xsl:call-template name="Scsi_Type">
						 <xsl:with-param name="Type" select="substring-before($Fld2,'revision')"/>
						 <xsl:with-param name="Revision" select="$Fld4"/>
				     </xsl:call-template>
				     </ATTACHEDTYPE>
				</xsl:when>
		</xsl:choose>
    </xsl:for-each>
    
</xsl:template>

<xsl:template name="Scsi_Host">
	<xsl:param name="Host"/>
	<xsl:param name="Channel"/>
	<xsl:param name="SC_ID"/>
	<xsl:param name="LUN"/>

	<Host displayname="Host" type="string"><xsl:value-of select="$Host"/></Host>
	<Channel displayname="Channel" type="string"><xsl:value-of select="$Channel"/></Channel>
	<SC_ID displayname="SCSI ID" type="string"><xsl:value-of select="$SC_ID"/></SC_ID>
	<LUN displayname="LUN" type="string"><xsl:value-of select="$LUN"/></LUN>
</xsl:template>

<xsl:template name="Scsi_Vendor">
	<xsl:param name="Vendor"/>
	<xsl:param name="Model"/>
	<xsl:param name="Revision"/>
	
	<Vendor displayname="Vendor" type="string"><xsl:value-of select="$Vendor"/></Vendor>
	<Model displayname="Model" type="string"><xsl:value-of select="$Model"/></Model>
	<Rev displayname="Rev" type="string"><xsl:value-of select="$Revision"/></Rev>
</xsl:template>

<xsl:template name="Scsi_Type">
	<xsl:param name="Type"/>
	<xsl:param name="Revision"/>
	
	<Type displayname="Type" type="string"><xsl:value-of select="$Type"/></Type>
	<Revision displayname="Revision" type="string"><xsl:value-of select="$Revision"/></Revision>
</xsl:template>

</xsl:stylesheet>
