<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:output method="xml" />
<xsl:strip-space elements="*"/>

<xsl:template match="/osda">
	<osda>
					<xsl:call-template name="Process" />
	</osda>
</xsl:template>

<xsl:template name="Process">

   <xsl:call-template name="Mods"/>

   <xsl:call-template name="ModConf"/>
   
   <xsl:call-template name="Drivers"/>
   
	<SMStatus>0</SMStatus>
</xsl:template>

<xsl:template name="Mods">
    <xsl:for-each select=" Label[position() &gt; 3] ">
             <xsl:if test="@section = 'lsmod' ">
			   <xsl:variable name="Fld1" select="normalize-space(substring-before(.,' '))"/>
			   <xsl:variable name="Fld2" select="normalize-space(substring-after(.,'  '))"/>
			   <xsl:variable name="Fld3" select="substring-after($Fld2,' ')"/>
			   <xsl:variable name="Fld4" select="substring-after($Fld3,' ')"/>
			   
			   <MODULES>
				   <Name displayname="Internal Name" type="string" ><xsl:value-of select="$Fld1"/></Name>
				   <Size displayname="Module size" type="string" unit="KB" ><xsl:value-of select="substring-before($Fld2,' ')"/></Size>
				   <UseCount displayname="Use Count" type="int">
						   <xsl:choose>
								<xsl:when test="string-length(substring-before($Fld3,' ')) &gt; 0 ">
									 <xsl:value-of select="number(substring-before($Fld3,' '))"/>
								</xsl:when>
								<xsl:otherwise>
									 <xsl:value-of select="number($Fld3)"/>
								</xsl:otherwise>
							</xsl:choose>
				  </UseCount>
				   <Dependant displayname="Dependant Modules" type="string"><xsl:value-of select="$Fld4"/></Dependant>
				   <Status  displayname="Status" type="string">
					   <xsl:choose>
									<xsl:when test="number($Fld3) = 0 ">
										<!-- XLATEBegin -->Unused<!--XLATEEND -->
									</xsl:when>
									<xsl:otherwise>
										<!-- XLATEBegin -->Running<!--XLATEEND -->
									</xsl:otherwise>
								</xsl:choose>
				   </Status>
				   
			   </MODULES>
			   <Drivers>
				   <Name displayname="Internal Name" type="string" ><xsl:value-of select="$Fld1"/></Name>
				   <Size displayname="Module size" type="string" unit="KB" ><xsl:value-of select="substring-before($Fld2,' ')"/></Size>
				   <Start displayname="Start" type="string"><xsl:value-of select="$Fld1"/></Start>
				   <Version  displayname="Version" type="string"><xsl:call-template name="FindMod"><xsl:with-param name="Target" select="$Fld1"/> </xsl:call-template>
				   </Version>
				   <Status  displayname="Status" type="string">
					   <xsl:choose>
									<xsl:when test="number($Fld3) =  0">
										<!-- XLATEBegin -->Unused<!--XLATEEND -->
									</xsl:when>
									<xsl:otherwise>
										<!-- XLATEBegin -->Running<!--XLATEEND -->
									</xsl:otherwise>
								</xsl:choose>
				   </Status>
			   </Drivers>

			</xsl:if>
    </xsl:for-each>
</xsl:template>

<xsl:template name="FindMod">
<xsl:param name="Target"/>
<xsl:for-each select="//Label[substring(@section,1,11) = 'lib/modules' ] ">
						   <xsl:choose>
										<xsl:when test="contains(@hint,$Target)">
										   <xsl:value-of select="@hint"/>
										</xsl:when>
									</xsl:choose>
				   </xsl:for-each>
</xsl:template>

<xsl:template name="Drivers">
    <xsl:for-each select="Label">
			   <xsl:if test="substring(@section,1,11) = 'lib/modules' ">
							<LIB_MODULES>
			                   <xsl:variable name="Fld1" select="substring-before(normalize-space(.),':')"/>
			                   <xsl:variable name="Fld2" select="substring-after(.,': ')"/>
			                  
			                   <Name displayname="Name" type="string"><xsl:value-of select="$Fld1"/></Name>
			                   <Path  displayname="Module Path" type="string"><xsl:value-of select="$Fld2"/></Path>
							</LIB_MODULES>
					</xsl:if>		
    </xsl:for-each>
    
</xsl:template>

<xsl:template name="ModConf">
    <xsl:for-each select="Label">
			   <xsl:if test="@section = 'etc/modprobe.conf' ">
			       <xsl:if test="substring(.,1,3) != '---'">
			                   <xsl:variable name="Fld1" select="substring-before(.,' ')"/>
			                   <xsl:variable name="Fld2" select="substring-after(normalize-space(.),' ')"/>
			                   <xsl:variable name="Fld3" select="substring-after($Fld2,' ')"/>
								<MODCONF>
										<Type displayname="{@hint}" type="string"><xsl:value-of select="$Fld1"/></Type>
										<Command displayname="Module Name" type="string" ><xsl:value-of select="substring-before($Fld2,' ')"/></Command>
										<Options displayname="Options" type="string" ><xsl:value-of select="$Fld3"/></Options>
								</MODCONF>			  
					</xsl:if>
			   </xsl:if>
    </xsl:for-each>
    
</xsl:template>

</xsl:stylesheet>
