<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:output method="xml" />
<xsl:strip-space elements="*"/>

<xsl:template match="/osda">
	<osda>
		   <xsl:choose>
		   			<xsl:when test="//SMStatus = 0">
                                                [abbbg]
						<xsl:call-template name="Process" />
					</xsl:when>
					<xsl:when test = "//SMStatus &lt; 1">
                                                [acccg]
						<xsl:call-template name="NoSource" />
					</xsl:when>
					<xsl:otherwise>
                                                [adddg]
						<xsl:call-template name="NoSource" />
					</xsl:otherwise>
			</xsl:choose>
	</osda>
</xsl:template>

<xsl:template name="NoSource">
  <SMStatus>-1</SMStatus>
</xsl:template>

<xsl:template name="Process">

 <xsl:variable name="BootStart" >
	 <xsl:value-of select="Label[@hint='/boot:']/@lineno "/>
 </xsl:variable>
 <xsl:variable name="BootStop" >
	 <xsl:value-of select="Label[@hint='/boot:']/@lineno "/>	 
 </xsl:variable>
 
   <xsl:call-template name="Boot">
	   <xsl:with-param name="BootStart" select="$BootStart"/>
	   <xsl:with-param name="BootStop" select="$BootStop"/>
   </xsl:call-template>

   <xsl:call-template name="Menu"/>
   
   <xsl:call-template name="Device"/>
   
  <SMStatus>0</SMStatus>
	
</xsl:template>

<xsl:template name="Menu">
    <xsl:for-each select=" Label ">
		<xsl:if test="@section = 'boot/grub/menu.lst' ">
			<xsl:if test="@hint != ' ' ">
			   <xsl:variable name="Fld1" select="normalize-space(substring-before(.,' '))"/>
			   <xsl:variable name="Fld2" select="normalize-space(substring-after(.,' ' ) ) "/>
			   
			<BOOTMENU>
				<ITEM displayname="{@hint}" type="string"  ><xsl:value-of select="$Fld1"/></ITEM>
				<VALUE displayname="Value" type="string" ><xsl:value-of select="$Fld2"/></VALUE>
			</BOOTMENU>
			
			</xsl:if>
		</xsl:if>
      <!-- For ESX 4 -->
      <xsl:if test="@section = 'boot/grub/grub.conf' ">
        <xsl:if test="@hint != ' ' ">
          <xsl:variable name="Fld1" select="normalize-space(substring-before(.,' '))"/>
          <xsl:variable name="Fld2" select="normalize-space(substring-after(.,' ' ) ) "/>

          <BOOTMENU>
            <ITEM displayname="{@hint}" type="string"  >
              <xsl:value-of select="$Fld1"/>
            </ITEM>
            <VALUE displayname="Value" type="string" >
              <xsl:value-of select="$Fld2"/>
            </VALUE>
          </BOOTMENU>

        </xsl:if>
      </xsl:if>
    </xsl:for-each>
</xsl:template>

<xsl:template name="Boot">
  <xsl:param name="BootStart"/>
  <xsl:param name="BootStop"/>
    [here]
    <xsl:for-each select="Label">
			   <xsl:if test="@section = 'ls-boot' ">
                                [Checking the Issue]
			        <!-- We want ot skip over the initial 7 lines of text that contains Uptime info and Memory use-->
			         <xsl:if test="number(@lineno) &gt; (number($BootStart)+1) ">
			                   <xsl:variable name="Fld1" select="normalize-space(substring-before(.,' '))"/>
			                   <xsl:variable name="Fld2" select="normalize-space(substring-after(.,' '))"/>
			                   <xsl:variable name="Fld3" select="substring-after($Fld2,' ')"/>
			                   <xsl:variable name="Fld4" select="substring-after($Fld3,' ')"/>
			                   <xsl:variable name="Fld5" select="substring-after($Fld4,' ')"/>
			                   <xsl:variable name="Fld6" select="substring-after($Fld5,' ')"/>
			                   <xsl:variable name="Fld7" select="substring-after($Fld6,' ')"/>
			                   <xsl:variable name="Fld8" select="substring-after($Fld7,' ')"/>
			                   <xsl:variable name="Fld9" select="substring-after($Fld8,' ')"/>
			                   
							   <xsl:variable name="FDate">
											   <xsl:value-of select="substring-before($Fld6,' ') "/><xsl:value-of select="string(' ')"/>
											   <xsl:value-of select="substring-before($Fld7,' ') "/><xsl:value-of select="string(' ')"/>
											   <xsl:value-of select="substring-before($Fld8,' ') "/>
						      </xsl:variable> 
			                   [variable are set]
			                   <xsl:choose>
										<xsl:when test="number(@lineno) &lt; (number($BootStop) - 2) ">
                                                                                 [Inside Choose]
										<BOOTLIST>
											   <Flags  displayname="Rights" type="string"><xsl:value-of select="$Fld1"/></Flags>
											   <Number  displayname="Number" type="string" ><xsl:value-of select="substring-before($Fld2,' ')"/> </Number>
											   <Owner  displayname="Owner" type="string" ><xsl:value-of select="substring-before($Fld3,' ')"/></Owner>
											   <User  displayname="User" type="string"  ><xsl:value-of select="substring-before($Fld4,' ')"/></User>
											   <Date  displayname="FileDate" type="string"  ><xsl:value-of select="$FDate"/></Date>
											   <Process  displayname="Process" type="string"><xsl:value-of select="$Fld9"/></Process>
										</BOOTLIST>	
										</xsl:when>
										
										<xsl:when test="number(@lineno) &gt;(number($BootStop)+1)">
										<BOOTGRUB>
											   <Flags  displayname="Rights" type="string"><xsl:value-of select="$Fld1"/></Flags>
											   <Number  displayname="Number" type="string" ><xsl:value-of select="substring-before($Fld2,' ')"/> </Number>
											   <Owner  displayname="Owner" type="string" ><xsl:value-of select="substring-before($Fld3,' ')"/></Owner>
											   <User  displayname="User" type="string"  ><xsl:value-of select="substring-before($Fld4,' ')"/></User>
											   <Date  displayname="FileDate" type="string"  ><xsl:value-of select="$FDate"/></Date>
											   <Process  displayname="Process" type="string"><xsl:value-of select="$Fld9"/></Process>
										</BOOTGRUB>
										</xsl:when>
								</xsl:choose>
					</xsl:if>		
			   </xsl:if>
    </xsl:for-each>
    
</xsl:template>

<xsl:template name="Device">
    <xsl:for-each select="Label ">
		<xsl:if test="@section = 'boot/grub/device.map' ">
			<xsl:if test="@hint != ' ' ">
			   <xsl:variable name="Fld1" select="normalize-space(substring-before(.,' '))"/>
			   <xsl:variable name="Fld2" select="normalize-space(substring-after(.,' '))"/>
			   
			<BOOTDEVICE>
				<ITEM displayname="{@hint}" type="string"  ><xsl:value-of select="$Fld1"/></ITEM>
				<VALUE displayname="Value" type="string" ><xsl:value-of select="$Fld2"/></VALUE>
			</BOOTDEVICE>
			
			</xsl:if>
		</xsl:if>
    </xsl:for-each>
</xsl:template>

</xsl:stylesheet>
