<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:output method="xml" />
<xsl:strip-space elements="*"/>



<xsl:template match="/osda">
	<osda>
		   <xsl:choose>
		   			<xsl:when test="//SMStatus = 0">
						<xsl:call-template name="Process" />
					</xsl:when>
					<xsl:when test = "//SMStatus &lt; 1">
						<xsl:call-template name="NoSource" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="NoSource" />
					</xsl:otherwise>
			</xsl:choose>
	</osda>
</xsl:template>

<xsl:template name="NoSource">
  <SMStatus>-1</SMStatus>
</xsl:template>

<xsl:template name="Process">
   <xsl:if test="Label/@hint ='Bus' ">
		<USB>
		<xsl:for-each select="Label">
			<!-- We must read this from the last line first so we can provide Name and then PnPDeviceID otherwise we get them inverted -->
			<xsl:sort  data-type="number" order="descending" select="@lineno"/>
				 <xsl:if test="@hint = 'Bus' ">
				  <PnPDeviceID displayname="Device ID" type="string">
					<xsl:value-of select="substring-after(normalize-space(node()) ,' ')"/>
					</PnPDeviceID>
					</xsl:if>
					<xsl:if test="@hint='iProduct' ">
					   <Name displayname="Name" type="string">
						<xsl:value-of select="substring-after(substring-after(node(),' '),' ')"/>
						</Name>
					</xsl:if>
		</xsl:for-each>
		</USB>
		</xsl:if>
   <xsl:if test="Label/@hint ='T:' ">
		<USB>
		<xsl:for-each select="Label">
			<!-- We must read this from the last line first so we can provide Name and then PnPDeviceID otherwise we get them inverted -->
			<xsl:sort  data-type="number" order="descending" select="@lineno"/>
				 <xsl:if test="substring(substring-after(normalize-space(node()),' '),1,3) = 'Bus' ">
				  <PnPDeviceID displayname="Device ID" type="string">
					<xsl:value-of select="substring-after(normalize-space(node()) ,' ')"/>
					</PnPDeviceID>
					</xsl:if>
					<xsl:if test="substring(substring-after(normalize-space(node()),' '),1,7) = 'Product' ">
					   <Name displayname="Name" type="string">
						<xsl:value-of select="substring-after(normalize-space(node()),'=')"/>
						</Name>
					</xsl:if>
		</xsl:for-each>
		</USB>
		</xsl:if>

	<xsl:call-template name="LinUSB"/>
 <SMStatus>0</SMStatus>
	
</xsl:template>

<xsl:template name="LinUSB">
  <xsl:choose>
			<xsl:when test="Label/@hint='Bus'">
				<LinUSB>
				<xsl:for-each select="Label">
						<Item displayname="{@hint}" type="string">
						<xsl:value-of select="substring-after(node(),' ')"/>
						</Item>
				</xsl:for-each>
				</LinUSB>
			</xsl:when>
			<xsl:when test="Label/@hint='T:'">
				<LinUSB>
				<xsl:for-each select="Label">
						<Item displayname="{substring-before(substring-after(normalize-space(node()),' '),'=')}" type="string">
						<xsl:value-of select="substring-after(normalize-space(node()),':')"/>
						</Item>
				</xsl:for-each>
				</LinUSB>
			</xsl:when>
		</xsl:choose>

</xsl:template>



</xsl:stylesheet>
