<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:output method="xml" />
<xsl:strip-space elements="*"/>

<xsl:template match="/osda">
	<osda>
		   <xsl:choose>
		   			<xsl:when test="//SMStatus = 0">
						<xsl:call-template name="Process" />
					</xsl:when>
					<xsl:when test = "//SMStatus &lt; 1">
						<xsl:call-template name="NoSource" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="NoSource" />
					</xsl:otherwise>
			</xsl:choose>
	</osda>
</xsl:template>

<xsl:template name="NoSource">
  <SMStatus>-1</SMStatus>
</xsl:template>

<xsl:template name="Process">

 <xsl:variable name="FileStart" >
	 <xsl:value-of select="Label[contains(node(),'&quot;Files&quot;') and @hint='Section']/@lineno "/>
 </xsl:variable>
 
 <xsl:variable name="ServerFlagStart" >
	 <xsl:value-of select="Label[contains(node(),'&quot;ServerFlags&quot;') and @hint='Section']/@lineno "/>
 </xsl:variable>

 <xsl:variable name="ModuleStart" >
	 <xsl:value-of select="Label[contains(node(),'&quot;Module&quot;') and @hint='Section']/@lineno "/>
 </xsl:variable>
 
 <xsl:variable name="InputDeviceStart" >
	 <xsl:value-of select="Label[contains(node(),'&quot;InputDevice&quot;') and @hint='Section' ]/@lineno "/>
 </xsl:variable>

 <xsl:variable name="MonitorStart" >
	 <xsl:value-of select="Label[contains(node(),'&quot;Monitor&quot;') and @hint='Section']/@lineno "/>
 </xsl:variable>

 <xsl:variable name="ModesStart" >
	 <xsl:value-of select="Label[contains(node(),'&quot;Modes&quot;') and @hint='Section']/@lineno "/>
 </xsl:variable>

 <xsl:variable name="ScreenStart" >
	 <xsl:value-of select="Label[contains(node(),'Screen')  and @hint='Section']/@lineno "/>
 </xsl:variable>


 <xsl:variable name="DeviceStart" >
	 <xsl:value-of select="Label[contains(node(),'&quot;Device&quot;') and @hint='Section']/@lineno "/>
 </xsl:variable>

 <xsl:variable name="ServerLayoutStart" >
	 <xsl:value-of select="Label[contains(node(),'&quot;ServerLayout&quot;') and @hint='Section']/@lineno "/>
 </xsl:variable>

 <xsl:variable name="DRIStart" >
	 <xsl:value-of select="Label[contains(node(),'DRI') and @hint='Section']/@lineno "/>
 </xsl:variable>

<!--
FileStart= <xsl:value-of select="$FileStart" />
ServerLayoutStart= <xsl:value-of select="$ServerLayoutStart" />
ModuleStart= <xsl:value-of select="$ModuleStart" />
InputDevice =<xsl:value-of select="$InputDeviceStart" />
MonitorStart= <xsl:value-of select="$MonitorStart" />
ModesStart= <xsl:value-of select="$ModesStart" />
-->

<xsl:if test="$FileStart != '' ">
   <xsl:call-template name="Group">
      <xsl:with-param name="Section">Files</xsl:with-param>
     <!-- Pass in the next section start  and stop as delimiter-->
	   <xsl:with-param name="StartLine" select="$FileStart"/>
	   <xsl:with-param name="StopLine" select="$ServerFlagStart"/>
   </xsl:call-template>
  </xsl:if>

  <xsl:if test="$FileStart = '' ">
   <xsl:call-template name="Group">
      <xsl:with-param name="Section">Files</xsl:with-param>
     <!-- Pass in the next section start  and stop as delimiter-->
	   <xsl:with-param name="StartLine" select="1"/>
	   <xsl:with-param name="StopLine" select="$ServerFlagStart"/>
   </xsl:call-template>
  </xsl:if>

   
   <xsl:if test="$ServerFlagStart != '' ">
   <xsl:call-template name="Group">
	   <xsl:with-param name="Section">ServerFlags</xsl:with-param>
	   <xsl:with-param name="StartLine" select="$ServerFlagStart"/>
	   <xsl:with-param name="StopLine" select="$ModuleStart"/>
   </xsl:call-template>
   </xsl:if>

   <xsl:if test="$ModuleStart != '' ">
   <xsl:call-template name="Group">
	   <xsl:with-param name="Section">Module</xsl:with-param>
	   <xsl:with-param name="StartLine" select="$ModuleStart"/>
	   <xsl:with-param name="StopLine" select="$InputDeviceStart"/>
   </xsl:call-template>
   </xsl:if>
   
   <xsl:if test="$InputDeviceStart != '' ">
   <xsl:call-template name="Group">
	   <xsl:with-param name="Section">InputDevice</xsl:with-param>
	   <xsl:with-param name="StartLine" select="$InputDeviceStart"/>
	   <xsl:with-param name="StopLine" select="$MonitorStart"/>
   </xsl:call-template>
   </xsl:if>
   
<xsl:if test="$MonitorStart != '' ">
   <xsl:call-template name="Group">
	   <xsl:with-param name="Section">Monitor</xsl:with-param>
	   <xsl:with-param name="StartLine" select="$MonitorStart"/>
	   <xsl:with-param name="StopLine" select="$ModesStart"/>
   </xsl:call-template>
  </xsl:if>
   
   <xsl:if test="$ModesStart != '' ">
   <xsl:call-template name="Group">
	   <xsl:with-param name="Section">Modes</xsl:with-param>
	   <xsl:with-param name="StartLine" select="$ModesStart"/>
	   <xsl:with-param name="StopLine" select="$ScreenStart"/>
   </xsl:call-template>
   </xsl:if>

   <xsl:if test="$ScreenStart != ''  ">
   <xsl:call-template name="Group">
	   <xsl:with-param name="Section">Screen</xsl:with-param>
	   <xsl:with-param name="StartLine" select="$ScreenStart"/>
	   <xsl:with-param name="StopLine" select="$DeviceStart"/>
   </xsl:call-template>
   </xsl:if>

   <xsl:if test="$DeviceStart != '' ">
   <xsl:call-template name="Group">
	   <xsl:with-param name="Section">Device</xsl:with-param>
	   <xsl:with-param name="StartLine" select="$DeviceStart"/>
	   <xsl:with-param name="StopLine" select="$ServerLayoutStart"/>
   </xsl:call-template>
   </xsl:if>

   <xsl:if test="$ServerLayoutStart != '' " >
   <xsl:call-template name="Group">
	   <xsl:with-param name="Section">ServerLayout</xsl:with-param>
	   <xsl:with-param name="StartLine" select="$ServerLayoutStart"/>
	   <xsl:with-param name="StopLine" select="$DRIStart"/>
   </xsl:call-template>
   </xsl:if>
   
    <xsl:if test="$DRIStart != '' " >
   <xsl:call-template name="Group">
	   <xsl:with-param name="Section">DRI</xsl:with-param>
	   <xsl:with-param name="StartLine" select="$DRIStart"/>
	   <xsl:with-param name="StopLine" select="number($DRIStart)+10"/>
   </xsl:call-template>
   </xsl:if>

  <SMStatus>0</SMStatus>
	
</xsl:template>


<xsl:template name="Group">
  <xsl:param name="Section"/>
  <xsl:param name="StartLine"/>
  <xsl:param name="StopLine"/>
  <xsl:variable name="EndLine"><xsl:value-of select="number($StartLine) + 5" /></xsl:variable>
  <!--- This variable will be used as a factor to expand the Display Section for Screen only-->
  <xsl:variable name="DisplayCount" >
     <xsl:choose>
						<xsl:when test="$Section = 'Screen' ">
							 <xsl:value-of select="count(Label[contains(node(),'Display')])*3 "/>
						</xsl:when>
						<xsl:otherwise>
							 <xsl:value-of select="3"/>
						</xsl:otherwise>
    </xsl:choose>
   </xsl:variable>
  
    <xsl:for-each select="Label">
			   <xsl:if test="number(@lineno) &gt; number($StartLine) ">
			        <!-- We want to stay between start and stop-->
			        <xsl:choose>
						<xsl:when test="$StopLine = ''  ">
								 <xsl:if test="number(@lineno) &lt;= number($EndLine) ">
									 <xsl:if test="@hint != 'EndSection'">
										   <xsl:variable name="Fld1" select="normalize-space(substring-after(normalize-space(node()),' '))"/>
										   <xsl:variable name="Fld2" select="substring-after($Fld1,'  ')"/>
											<Section name="{$Section}">
												<Item displayname="{@hint}" type="string"><xsl:value-of select="$Fld1"/></Item>
											</Section>	
									</xsl:if>				
							   </xsl:if>		
							</xsl:when>				   
						<xsl:when test="$StopLine != '' and ($StopLine &gt; $StartLine) ">
								 <xsl:if test="number(@lineno) &lt;= number($StopLine) ">
									 <xsl:if test="@hint != 'EndSection'">
										   <xsl:variable name="Fld1" select="normalize-space(substring-after(normalize-space(node()),' '))"/>
										   <xsl:variable name="Fld2" select="substring-after($Fld1,' ')"/>
											<Section name="{$Section}">
												<Item displayname="{@hint}" type="string"><xsl:value-of select="$Fld1"/></Item>
											</Section>	
									</xsl:if>				
							   </xsl:if>		
							</xsl:when>				   
						<xsl:when test="$StopLine != '' and ($StopLine &lt; $StartLine) ">
								 <xsl:if test="number(@lineno) &lt;= number($EndLine)+number($DisplayCount)  ">
									 <xsl:if test="@hint != 'EndSection'">
										   <xsl:variable name="Fld1" select="normalize-space(substring-after(normalize-space(node()),' '))"/>
										   <xsl:variable name="Fld2" select="substring-after($Fld1,'  ')"/>
											<Section name="{$Section}">
												<Item displayname="{@hint}" type="string"><xsl:value-of select="$Fld1"/></Item>
											</Section>	
									</xsl:if>				
							   </xsl:if>		
							</xsl:when>				   
							
				</xsl:choose>

			   </xsl:if>
    </xsl:for-each>
    
</xsl:template>


</xsl:stylesheet>
