#!/bin/bash

cd $1
chmod +x bin/7z bin/7z.so

if [ -e config.zip ] ; then
        ./bin/7z x  config.zip >/dev/null 2>&1
		mv config/reports/indexTOC_Linux.txt config/reports/indexTOC.txt
        rm -f config.zip
fi

cd $1/bin
if [ -e Linux_x64.zip ] ; then
        ./7z x  Linux_x64.zip >/dev/null 2>&1
        cp 7z Linux_x64/
        cp 7z.so Linux_x64/
        rm -f 7z*
        rm -f Linux_x64.zip
fi

cd Linux_x64
chmod +x 7z 7z.so

OS_R=RHEL
if [ -f /etc/redhat-release ];then
        cat /etc/redhat-release | grep "8.0" > /dev/null 2>&1
        if [ $? == 0 ];then
                OS_R="RHEL8"
        fi
fi

if [  -f /etc/SUSE-brand ] || [ "$OS_R" == "RHEL8" ]; then
    echo ""
else
	ln -s libxml2.so.2.9.10 libxml2.so >/dev/null 2>&1
	ln -s libxml2.so.2.9.10 libxml2.so.2 >/dev/null 2>&1
	ln -s libxslt.so.1.1.34 libxslt.so >/dev/null 2>&1
	ln -s libxslt.so.1.1.34 libxslt.so.1 >/dev/null 2>&1
fi

export LD_LIBRARY_PATH=.:./lib:$LD_LIBRARY_PATH


./collector $2 $3

cd /tmp
rm -rf $1
rm $0
