#!/bin/bash
MUT_FILE_PATH="/tmp/.dcismmutlogger"
ISM_MUT_LOGGER="/opt/dell/srvadmin/iSM/lib64/dcism/ismmutlogger"
DEFAULT_RPM_PARAM="install:watchdog,lclog,osinfo:remove:null,installmethod=rpm"
DEFAULT_REMOVE_RPM_PARAM="install:null:remove:watchdog,lclog,osinfo,installmethod=rpm"
DEFAULT_DEB_PARAM="install:watchdog,lclog,osinfo:remove:null,installmethod=debian"
DEFAULT_REMOVE_DEB_PARAM="install:null:remove:watchdog,lclog,osinfo,installmethod=debian"
OS_TYPE="UNKNOWN"

getOS()
{ 
    if [ -f /etc/os-release ]; then 		
        . /etc/os-release
		OS=$NAME
		VER=`echo $VERSION_ID | cut -d"." -f1`		
		# check if operating system is UBUNTU18
		if [ "$OS" = "Ubuntu" ] && [ "$VER" = "18" ]; then
			OS_TYPE="UBUNTU18"
		fi
		#check for SLES15
		if [ "$OS" = "SLES" ] && [ "$VER" = "15" ]; then
			OS_TYPE="SLES15"
		fi
		#check for RHEL7
        if [  "$VER" = "7" ]; then				
			OS_TYPE="RHEL7"				
		fi
		#check for RHEL8
        if [  "$VER" = "8" ]; then
			OS_TYPE="RHEL8"
		fi
		# check if operating system is CentOS
		cat /etc/os-release | grep NAME | grep -i CentOS >/dev/null 2>&1
        if [ $? -eq 0 ]; then
			OS_TYPE="CENTOS"
        fi
		# check if operating system is Xen
		cat /etc/os-release | grep "XenServer"  > /dev/null
		if [ $? -eq 0 ]; then
			OS_TYPE="XEN"
		fi
		# check if operating system is Debian
		cat /etc/os-release | grep NAME | grep -i Debian >/dev/null 2>&1
        if [ $? -eq 0 ]; then
			OS_TYPE="DEBIAN"
        fi
		#check for AHV
        if [  "$ID" = "ahv" ]; then
			OS_TYPE="AHV"
		fi
    fi
}


if [ -f $MUT_FILE_PATH ]; then
	mut_params=`cat $MUT_FILE_PATH`
	$ISM_MUT_LOGGER $mut_params
	rm -f $MUT_FILE_PATH
else
	getOS
	if [ "$OS_TYPE" = "UBUNTU16" ] || [ "$OS_TYPE" = "UBUNTU18" ] || [ "$OS_TYPE" = "DEBIAN" ]; then
		if [ $2 -ne 0 ]; then
			$ISM_MUT_LOGGER $1 os=$OS_TYPE"."$DEFAULT_DEB_PARAM
		else
			$ISM_MUT_LOGGER $1 os=$OS_TYPE"."$DEFAULT_REMOVE_DEB_PARAM
		fi
	else
		if [ $2 -ne 0 ]; then
			$ISM_MUT_LOGGER $1 os=$OS_TYPE"."$DEFAULT_RPM_PARAM
		else
			$ISM_MUT_LOGGER $1 os=$OS_TYPE"."$DEFAULT_REMOVE_RPM_PARAM
		fi
	fi
fi
