#!/bin/bash
#-------------------------------------------------------------------------
#
#          DELL COMPUTER CORPORATION PROPRIETARY INFORMATION
#
#  This software is supplied under the terms of a license agreement or
#  nondisclosure agreement with Dell Computer Corporation and may not
#  be copied or disclosed except in accordance with the terms of that
#  agreement.
#
#  Copyright (c) 2021 Dell Computer Corp. All Rights Reserved.
#
#  Abstract/Purpose:
#  This script get the software package info
#------------------------------------------------------------------------

ISM_PACKAGE_INSTALLDATE_FILE="/opt/dell/srvadmin/iSM/etc/ini/software-package.ini"

InsertDevIntfDriver()
{
	modprobe ipmi_devintf > /dev/null 2>&1
}

SetiSMInstallDateTime()
{
	if [ -e /etc/debian_version ];then
		iSMInstallDateTime=`stat /var/lib/dpkg/info/dcism.list | grep Modify: | cut -d ' ' -f 2`
	else	        
			iSMInstallDateTime=`/bin/rpm -q --qf '%{INSTALLTIME:date}\n' dcism`
            iSMInstallDateTime=$(date -d "$iSMInstallDateTime" +"%m/%d/%Y");

	fi
        echo "[dcism]" > ${ISM_PACKAGE_INSTALLDATE_FILE}
        echo "InstallDateTime=$iSMInstallDateTime" >> ${ISM_PACKAGE_INSTALLDATE_FILE}
        return
} #SetiSMInstallDateTime

CheckandResoreiSMConfigFiles()
{
if [ ! -f /opt/dell/srvadmin/iSM/etc/ini/dcismdy64.ini ] || [ ! -s /opt/dell/srvadmin/iSM/etc/ini/dcismdy64.ini ]
then
        if [ -f /opt/dell/srvadmin/iSM/etc/ini/dcismdy64.ini.orig ]
        then
          cp -p /opt/dell/srvadmin/iSM/etc/ini/dcismdy64.ini.orig /opt/dell/srvadmin/iSM/etc/ini/dcismdy64.ini
          logger  "iDRAC Service Module has restored the configuration file dcismdy64.ini."
        fi
fi

if [ ! -f /opt/dell/srvadmin/iSM/etc/ini/dcos2idrac.ini ] || [ ! -s /opt/dell/srvadmin/iSM/etc/ini/dcos2idrac.ini ]
then
        if [ -f /opt/dell/srvadmin/iSM/etc/ini/dcos2idrac.ini.orig ]
        then
          cp -p /opt/dell/srvadmin/iSM/etc/ini/dcos2idrac.ini.orig /opt/dell/srvadmin/iSM/etc/ini/dcos2idrac.ini
          logger  "iDRAC Service Module has restored the configuration file dcos2idrac.ini."
        fi
fi
}

InsertDevIntfDriver 
#Set iSM's install Date and Time
SetiSMInstallDateTime
#iSM will rstore the config files during service start 
#in case corrupted or file not found
CheckandResoreiSMConfigFiles
