#!/bin/bash
#-------------------------------------------------------------------------
#
#          DELL COMPUTER CORPORATION PROPRIETARY INFORMATION
#
#  This software is supplied under the terms of a license agreement or
#  nondisclosure agreement with Dell Computer Corporation and may not
#  be copied or disclosed except in accordance with the terms of that
#  agreement.
#
#  Copyright (c) 2013 Dell Computer Corp. All Rights Reserved.
#
#  Abstract/Purpose:
#  iSM OSBMC over usb Configuration script
#  This script detects the DELL USBNIC interface and trying to configure
#  the same using IPv4 Network, it is assumed that the consumer is
#  passing an IPv4 iDRAC USBNIC address for this script to configure the
#  host interface.
#------------------------------------------------------------------------


usb_bus_no=0
usb_device_no=0
USB_BUS_BASE_DIR="/sys/bus/usb/devices/usb"
UNIQUE_DEVICE_ID="413c:a102"


getUSBintfName()
{
usb_bus_no_str=`lsusb | grep -i $UNIQUE_DEVICE_ID | cut -d ":" -f 1 | cut -d " " -f 2`
usb_device_no_str=`lsusb | grep -i $UNIQUE_DEVICE_ID | cut -d ":" -f 1 | cut -d " " -f 4`
let usb_bus_no=$usb_bus_no+10#$usb_bus_no_str
let usb_device_no=$usb_device_no+10#$usb_device_no_str
#echo $usb_bus_no
#echo $usb_device_no
ethernet_interface_name_t=`find $USB_BUS_BASE_DIR$usb_bus_no/ | grep -i "net"  | head -1`
#echo $ethernet_interface_name_t
cdir=`pwd`
cd $ethernet_interface_name_t
cd ..

cdir1=`pwd`
nodename=`echo $cdir1/net`
if [ -e $nodename ]
then
ethernet_interface_name=`ls $cdir1/net`
echo $ethernet_interface_name
cd $cdir
return 0
fi

ethernet_interface_name_t=`ls | grep -i "net"`
if [ $? -eq 0 ]
then

#echo $ethernet_interface_name_t
ethernet_interface_name=`echo $ethernet_interface_name_t | cut -d ":" -f 2`
echo $ethernet_interface_name
cd $cdir
return 0

fi

cd $cdir
return 1

}

#call the getUSBintfName 
getUSBintfName;


