#!/bin/bash
#-------------------------------------------------------------------------
#
#          DELL COMPUTER CORPORATION PROPRIETARY INFORMATION
#
#  This software is supplied under the terms of a license agreement or
#  nondisclosure agreement with Dell Computer Corporation and may not
#  be copied or disclosed except in accordance with the terms of that
#  agreement.
#
#  Copyright (c) 2021 Dell Computer Corp. All Rights Reserved.
#
#  Abstract/Purpose:
#  Enable/Disable Host SNMP Trap feature of iDRAC Service Moudle.
#  Follow the EnableiDRACSNMPTrapusage() function for the usage guide.
#------------------------------------------------------------------------

EnableiDRACSNMPTrapusage()
{
	echo "Usage: Ensure Net-SNMP package is installed with SMUX and/or AGENTX support. the command usage is as follows -"
	echo "       Enable-iDRACSNMPTrap.sh 1/enable          => Enable SNMP trap feature in iDRAC Service Module; Net-SNMP trap configuration should be done by Server Administrator."
	echo "       Enable-iDRACSNMPTrap.sh 1/enable --force  => Enable SNMP trap feature in iDRAC Service Module; Net-SNMP re-configuration is attempted; Trap Destinations need to be configured by Server Administrator."
	echo "       Enable-iDRACSNMPTrap.sh 1/enable protocol 1/agentx  => Enable SNMP trap feature in iDRAC Service Module with AGENTX; Net-SNMP trap configuration should be done by Server Administrator."
	echo "       Enable-iDRACSNMPTrap.sh 1/enable protocol 1/agentx --force  => Enable SNMP trap feature in iDRAC Service Module with AGENTX; Net-SNMP re-configuration is attempted; Trap Destinations need to be configured by Server Administrator."
	echo "       Enable-iDRACSNMPTrap.sh 1/enable protocol 0/smux  => Enable SNMP trap feature in iDRAC Service Module with SMUX; Net-SNMP trap configuration should be done by Server Administrator."
	echo "       Enable-iDRACSNMPTrap.sh 1/enable protocol 0/smux --force  => Enable SNMP trap feature in iDRAC Service Module with SMUX; Net-SNMP re-configuration is attempted; Trap Destinations need to be configured by Server Administrator."
	echo "       Enable-iDRACSNMPTrap.sh 0/disable         => Disable SNMP trap feature in iDRAC Service Module; Net-SNMP configuration should be done by Server Administrator."
	echo "       Enable-iDRACSNMPTrap.sh 0/disable --force => Disable SNMP trap feature in iDRAC Service Module; Net-SNMP re-configuration is attempted."
	echo "       Enable-iDRACSNMPTrap.sh status 	       => Check if the feature is currently enabled."
	echo "       Enable-iDRACSNMPTrap.sh changesmuxpasswd <passowrd> => change the smux password. use enble/force option for the new password to take effect."
} 

DisplayLockdownModeMessage()
{
    echo "The System Configuration Lockdown mode is enabled. iDRAC Service Module feature configuration is blocked."
}

DisplayNoneModeMessage()
{
    echo "Unable to process the request due to one of the following reasons. 1) iSM service is not ready to accept requests. 2) iSM service is not running.Ensure the iSM service is running and try again later"
}

DisplayLimitedModeMessage()
{
    echo "The iDRAC Service Module is running with Limited Functionality Mode hence some features are unavailable. Possible reasons are: 1) OS-to-BMC Passthrough setting in iDRAC is disabled 2) USBNIC interface on the host OS does not have a configured IP address."
}
DisplaySNMPErrorMessage()
{
    echo "SNMP Trap feature could not be enabled, Ensure iSM service is running and retry the operation"
}

ServiceModuleTrapEnable()
{
	enableRet=0
	if [ "$1" == "1" ]
	then 
		# find which protocol is supported. By default we check if SMUX support is there. If not, we will try AGENTX
		ps -C snmpd -o pid= > /dev/null 2>&1
		if [ $? -eq 1 ]
		then
			echo "SNMPD Service is not running. Starting..."
			service snmpd start > /dev/null 2>&1
		fi

		ps -C snmpd -o command= | grep -q "\-I \-smux" > /dev/null 2>&1
		if [ $? -eq 1 ]
		then
			#Smux
			protval="0"
		else
			#AgentX
			protval="1"
		fi
		#Enable Trap and activate the configured protocol 
		/opt/dell/srvadmin/iSM/bin/dchosmicli 0 2 \"iDRAC.Embedded.1#ServiceModule.1#HostSNMPAlert=1\" > /dev/null 2>&1
		ret=$?
		if [ $ret -eq 0 ]
		then
			echo "$protval" > /opt/dell/srvadmin/iSM/etc/enable_trap

			if [ -f /opt/dell/srvadmin/iSM/etc/enable_trap ]
			then
				chmod 0644 /opt/dell/srvadmin/iSM/etc/enable_trap
			fi

			if [ $protval -eq 0 ]
			then
				echo "SNMP Trap feature is enabled in iDRAC Service Module with SMUX protocol."
			else
				echo "SNMP Trap feature is enabled in iDRAC Service Module with AGENTX protocol."
			fi
		else
			if [ $ret -eq 24 ]
			then
				DisplayLockdownModeMessage
			fi
			if [ $ret -eq 33 ]
			then
			    DisplayNoneModeMessage
			fi

			if [ $ret -eq 34 ]
			then
			    DisplayLimitedModeMessage
			else
			    DisplaySNMPErrorMessage
			fi
			enableRet=1
		fi
	else
		#Disable Trap
		/opt/dell/srvadmin/iSM/bin/dchosmicli 0 2 \"iDRAC.Embedded.1#ServiceModule.1#HostSNMPAlert=0\" > /dev/null 2>&1
		ret=$?
		if [ $ret -eq 0 ]
		then
			rm -f /opt/dell/srvadmin/iSM/etc/enable_trap
			echo "SNMP Trap feature is disabled in iDRAC Service Module."
		else
			if [ $ret -eq 24 ]
			then
				DisplayLockdownModeMessage
			fi
			if [ $ret -eq 33 ]
			then
			    DisplayNoneModeMessage
			fi

			if [ $ret -eq 34 ]
			then
			    DisplayLimitedModeMessage
			else
			    DisplaySNMPErrorMessage
			fi
			enableRet=1
		fi
	fi
	return $enableRet 
}

SMUXNotificationMsg()
{
	echo "iDRAC Service Module smux peer is configured, please ensure smux is enabled as primary snmp agent." 
}

ConfigureProtocol()
{
	if [ -e /etc/snmp/snmpd.conf ]
	then
		#Enable Trap and activate the configured protocol 
		/opt/dell/srvadmin/iSM/bin/dchosmicli 0 2 \"iDRAC.Embedded.1#ServiceModule.1#HostSNMPAlert=1\" > /dev/null 2>&1
		ret=$?
		if [ $ret -eq 0 ]
		then
		# update the protocol value 
			if [ "$1" == "1" ]
			then
				echo "1" > /opt/dell/srvadmin/iSM/etc/enable_trap
			else
				echo "0" > /opt/dell/srvadmin/iSM/etc/enable_trap
			fi
		else
			if [ $ret -eq 24 ]
			then
				DisplayLockdownModeMessage
			fi
			if [ $ret -eq 33 ]
			then
			    DisplayNoneModeMessage
			fi

			if [ $ret -eq 34 ]
			then
			    DisplayLimitedModeMessage
			else
			    DisplaySNMPErrorMessage
			fi
			enableRet=1
		fi
	else
		echo "Please install net-snmp and Enable In band SNMP Traps feature before Configuring!"
		exit 1
	fi
}

EnableiDRACSNMPConfigureNetSNMP()
{
	if [ "$1" == "1" ]
	then  
		if [ -e /etc/snmp/snmpd.conf ] 
		then
			line=$(< /opt/dell/srvadmin/iSM/etc/enable_trap)
			arrIN=(${line//;/ })
			protval=${arrIN[0]}
			activeStatus=${arrIN[1]}
			if [ $protval -eq 0 ]
			then
				cat /opt/dell/srvadmin/iSM/etc/ism_snmpd.conf >> /etc/snmp/snmpd.conf
			else
				#Check if the agent is already acting as primary agent
				grep -v \# /etc/snmp/snmpd.conf | grep -q "master agentx" > /dev/null 2>&1
				if [ $? -eq 1 ]
				then
				# Enable agent to act as primary agent 
					echo "primary agentx" >> /etc/snmp/snmpd.conf	
				fi
			fi
		else
			echo "Please install net-snmp to enable this feature!"
			exit 1
		fi
	else
		#restore
		cat /etc/snmp/snmpd.conf | grep -v "# Allows iDRAC Service Module to send trap via SMUX" | grep -v "smuxpeer .1.3.6.1.4.1.674.10892.5"  | grep -v "smuxpeer .1.3.6.1.4.1.674.10892.1" | grep -v "smuxpeer .1.3.6.1.4.1.674.10893.1" > /opt/dell/srvadmin/iSM/etc/snmpd_backup.conf
		mv /opt/dell/srvadmin/iSM/etc/snmpd_backup.conf /etc/snmp/snmpd.conf
	fi

	if [ -e /etc/init.d/snmpd ]
	then
		/etc/init.d/snmpd restart
		if [ $? -ne 0 ]
		then
			/etc/init.d/snmpd stop
			/etc/init.d/snmpd start
			if [ $? -ne 0 ]
			then
				echo "snmpd could not be started, please contact administrator to install and run net-snmp!!"
				exit 1
			fi
		fi
	else
		if [ -e /usr/bin/systemctl ] && [ -e /usr/lib/systemd/system/snmpd.service ]
		then
			systemctl enable snmpd.service
			systemctl restart snmpd.service
			if [ $? -ne 0 ]
			then
				echo "snmpd could not be started, please contact administrator to install and run net-snmp!!!!"
				exit 1
			fi
		else
			echo "Please install net-snmp to enable this feature!"
			exit 1
		fi
	fi
}

if [ $# -eq 0 ] || [ $# -gt 4 ]
then
	EnableiDRACSNMPTrapusage
	exit 1
fi
command="$1"
if [ "$command" == "1" ] || [ "$command" == "enable" ]
then
	if [ $# -eq 4 ]
	then
		if [ "$4" == "--force" ]
		then
			if [ "$2" == "protocol" ]
			then
				if [ "$3" == "1" ] || [ "$3" == "agentx" ]
				then
					ConfigureProtocol "1" 
					EnableiDRACSNMPConfigureNetSNMP "0"
					EnableiDRACSNMPConfigureNetSNMP "1"
					echo "SNMP Trap feature is configured with AGENTX. Please make sure AGENTX is supported by Primary Agent."
				elif [ "$3" == "0" ] || [ "$3" == "smux" ]
				then
					ConfigureProtocol "0" 
					EnableiDRACSNMPConfigureNetSNMP "0"
					EnableiDRACSNMPConfigureNetSNMP "1"
					echo "SNMP Trap feature is configured with SMUX. Please make sure SMUX is supported by Primary Agent."
					SMUXNotificationMsg
				else
					EnableiDRACSNMPTrapusage
					exit 1
				fi
			fi
		else
			EnableiDRACSNMPTrapusage
			exit 1
		fi
	elif [ $# -eq 3 ]
	then
		if [ "$2" == "protocol" ]
		then
			if [ "$3" == "1" ] || [ "$3" == "agentx" ]
			then
				ConfigureProtocol "1" 
				echo "Please configure the Net-SNMP as primary agent to send traps; ensure agentx is enabled and then restart the snmpd service."
			elif [ "$3" == "0" ] || [ "$3" == "smux" ]
			then
				ConfigureProtocol "0" 
				echo "Please configure the Net-SNMP as primary agent to send traps; ensure smux is enabled; for iDRAC Service Module smux peer configuration please consult /opt/dell/srvadmin/iSM/etc/ism_snmpd.conf and then restart the snmpd service."
			else
				EnableiDRACSNMPTrapusage
				exit 1
			fi
		else
			EnableiDRACSNMPTrapusage
			exit 1
		fi
	elif [ $# -eq 2 ]
	then
		if [ "$2" == "--force" ]
		then
			# Enable the trap with default Protocol before restarting the services
			ServiceModuleTrapEnable "1"
			if [ $? -ne 0 ]
			then
				exit 1
			fi
			EnableiDRACSNMPConfigureNetSNMP "0"
			EnableiDRACSNMPConfigureNetSNMP "1"
			protval=$(< /opt/dell/srvadmin/iSM/etc/enable_trap)
			if [ $protval -eq 0 ]
			then
				SMUXNotificationMsg
			fi
			exit 0
		else
			EnableiDRACSNMPTrapusage
			exit 1
		fi
	else
		ServiceModuleTrapEnable "1"
		if [ $? -ne 0 ]
		then
			exit 1
		fi
		protval=$(< /opt/dell/srvadmin/iSM/etc/enable_trap)
		if [ $protval -eq 0 ]
		then
			echo "Please configure the Net-SNMP as primary agent to send traps; ensure smux is enabled; for iDRAC Service Module smux peer configuration please consult /opt/dell/srvadmin/iSM/etc/ism_snmpd.conf and then restart the snmpd service."
		else
			echo "Please configure the Net-SNMP primary agent to send traps; ensure agentx is enabled and then restart the snmpd service."
		fi
		exit 0
	fi

elif [ "$command" == "0" ] || [ "$command" == "disable" ]
then
	# restore snmpd.conf
	if [ $# -eq 2 ]
	then
                if [ "$2" == "--force" ]
                then
			ServiceModuleTrapEnable "0"
			if [ $? -ne 0 ]
			then
				exit 1
			fi
                        EnableiDRACSNMPConfigureNetSNMP "0"
                        exit 0
                else
                        EnableiDRACSNMPTrapusage
                        exit 1
                fi
        else
		ServiceModuleTrapEnable "0"
		if [ $? -ne 0 ]
		then
			exit 1
		fi
                echo "Please re-configure the Net-SNMP primary agent by removing the smux peer entries for iDRAC Service Module. please consult /opt/dell/srvadmin/iSM/etc/ism_snmpd.conf for smux peer configuration of iDRAC Service Module."
                exit 0
        fi
elif [ "$command" == "status" ]
then
	if [ -e /opt/dell/srvadmin/iSM/etc/enable_trap ]
	then
		protval=$(< /opt/dell/srvadmin/iSM/etc/enable_trap)
		if [ $protval -eq 0 ]
		then
			echo "iDRAC Service Module SNMP Trap is enabled with SMUX."
		else
			echo "iDRAC Service Module SNMP Trap is enabled with AGENTX."
		fi
		exit 0
	else
		echo "iDRAC Service Module SNMP Trap is disabled."
		exit 1
	fi
elif [ "$command" == "changesmuxpasswd" ]
then
	if [ $# -eq 2 ]
	then
		echo "# Allows iDRAC Service Module to send trap via SMUX" > /opt/dell/srvadmin/iSM/etc/ism_snmpd.conf
		echo "smuxpeer .1.3.6.1.4.1.674.10892.5 $2" >> /opt/dell/srvadmin/iSM/etc/ism_snmpd.conf
		echo "smuxpeer .1.3.6.1.4.1.674.10892.1 $2" >> /opt/dell/srvadmin/iSM/etc/ism_snmpd.conf
		echo "smuxpeer .1.3.6.1.4.1.674.10893.1 $2" >> /opt/dell/srvadmin/iSM/etc/ism_snmpd.conf
	else
		EnableiDRACSNMPTrapusage
		exit 1
	fi
else 
	EnableiDRACSNMPTrapusage
	exit 1
fi

exit 0



