<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:output method="xml" />
<xsl:strip-space elements="*"/>



<xsl:template match="/osda">
	<osda>
		   <xsl:choose>
		   			<xsl:when test="//SMStatus = 0">
						<xsl:call-template name="Process" />
					</xsl:when>
					<xsl:when test = "//SMStatus &lt; 1">
						<xsl:call-template name="NoSource" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="NoSource" />
					</xsl:otherwise>
			</xsl:choose>
	</osda>
</xsl:template>

<xsl:template name="NoSource">
  <SMStatus>-1</SMStatus>
</xsl:template>

<xsl:template name="Process">

   <xsl:call-template name="IRQ"/>

  <SMStatus>0</SMStatus>
	
</xsl:template>

<xsl:template name="IRQ">
   <xsl:variable name="CPU0" select="normalize-space(node())"/>
   <xsl:variable name="CPU1" select="substring-after($CPU0,' ')"/>
   <xsl:variable name="CPU2" select="substring-after($CPU1,' ')"/>
   <xsl:variable name="CPU3" select="substring-after($CPU2,' ')"/>
   <xsl:variable name="CPU4" select="substring-after($CPU3,' ')"/>
   <xsl:variable name="CPU5" select="substring-after($CPU4,' ')"/>
   <xsl:variable name="CPU6" select="substring-after($CPU5,' ')"/>
   <xsl:variable name="CPU7" select="substring-after($CPU6,' ')"/>
      <xsl:choose>
	   <xsl:when test="string-length($CPU7) &gt; 3 ">
	   <xsl:call-template name="Device">
	      <xsl:with-param name="Count">8</xsl:with-param>
	      </xsl:call-template>
	   </xsl:when>   
	   <xsl:when test="string-length($CPU6) &gt; 3 ">
	   <xsl:call-template name="Device">
	      <xsl:with-param name="Count">7</xsl:with-param>
	      </xsl:call-template>
	   </xsl:when>   
	   <xsl:when test="string-length($CPU5) &gt; 3 ">
	   <xsl:call-template name="Device">
	      <xsl:with-param name="Count">6</xsl:with-param>
	      </xsl:call-template>
	   </xsl:when>   
	   <xsl:when test="string-length($CPU4) &gt; 3 ">
	   <xsl:call-template name="Device">
	      <xsl:with-param name="Count">5</xsl:with-param>
	      </xsl:call-template>
	   </xsl:when>   
	   <xsl:when test="string-length($CPU3) &gt; 3 ">
	   <xsl:call-template name="Device">
	      <xsl:with-param name="Count">4</xsl:with-param>
	      </xsl:call-template>
	   </xsl:when>   
	   <xsl:when test="string-length($CPU2) &gt; 3 ">
	   <xsl:call-template name="Device">
	      <xsl:with-param name="Count">3</xsl:with-param>
	      </xsl:call-template>
	   </xsl:when>   
	   <xsl:when test="string-length($CPU1) &gt; 3 ">
	   <xsl:call-template name="Device">
	      <xsl:with-param name="Count">2</xsl:with-param>
	      </xsl:call-template>
	   </xsl:when>   
	   <xsl:when test="string-length($CPU0) &gt; 3 ">
	   <xsl:call-template name="Device">
	      <xsl:with-param name="Count">1</xsl:with-param>
	      </xsl:call-template>
	   </xsl:when>   
   </xsl:choose>
</xsl:template>   

<xsl:template name="Device">
   <xsl:param name="Count"/>
   <xsl:for-each select="Label[@lineno &gt; 1]">
    <DEVICEIRQ>
			   <xsl:variable name="Fld1" select="substring-before(normalize-space(node()),' ')"/>
			   <xsl:variable name="Fld2" select="substring-after(normalize-space(node()),' ')"/>
			   <xsl:variable name="Fld3" select="substring-after($Fld2,' ')"/>
			   <xsl:variable name="Fld4" select="substring-after($Fld3,' ')"/>
			   <xsl:variable name="Fld5" select="substring-after($Fld4,' ')"/>
			   <xsl:variable name="Fld6" select="substring-after($Fld5,' ')"/>
			   <xsl:variable name="Fld7" select="substring-after($Fld6,' ')"/>
			   <xsl:variable name="Fld8" select="substring-after($Fld7,' ')"/>
			   <xsl:variable name="Fld9" select="substring-after($Fld8,' ')"/>
			   <xsl:variable name="Fld10" select="substring-after($Fld9,' ')"/>
			   
				<IRQ displayname="{@hint}" type="uint">
					<xsl:value-of select="@hint"/>
				</IRQ>
				<Device displayname="Device" type="string">
				<xsl:choose>
					<xsl:when test="number($Count) = 8">
						<xsl:value-of select="$Fld2"/>
					</xsl:when>
					<xsl:when test="number($Count) = 7">
						<xsl:value-of select="substring-after($Fld8,' ')"/>
					</xsl:when>
					<xsl:when test="number($Count) = 6">
						<xsl:value-of select="substring-after($Fld7,' ')"/>
					</xsl:when>
					<xsl:when test="number($Count) = 5">
						<xsl:value-of select="substring-after($Fld6,' ')"/>
					</xsl:when>
					<xsl:when test="number($Count) = 4">
						<xsl:value-of select="substring-after($Fld5,' ')"/>
					</xsl:when>
					<xsl:when test="number($Count) = 3">
						<xsl:value-of select="substring-after($Fld4,' ')"/>
					</xsl:when>
					<xsl:when test="number($Count) = 2">
						<xsl:value-of select="substring-after($Fld3,' ')"/>
					</xsl:when>
					<xsl:when test="number($Count) = 1">
						<xsl:value-of select="substring-after($Fld2,' ')"/>
					</xsl:when>
				</xsl:choose>
				</Device>
  </DEVICEIRQ>
    </xsl:for-each>
  </xsl:template>


</xsl:stylesheet>
