<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:output method="xml" />
<xsl:strip-space elements="*"/>

<xsl:template match="/osda">
	<osda>
		   <xsl:choose>
		   			<xsl:when test="//SMStatus = 0">
						<xsl:call-template name="Process" />
					</xsl:when>
					<xsl:when test = "//SMStatus &lt; 1">
						<xsl:call-template name="NoSource" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="NoSource" />
					</xsl:otherwise>
			</xsl:choose>
	</osda>
</xsl:template>

<xsl:template name="NoSource">
  <SMStatus>-1</SMStatus>
</xsl:template>

<xsl:template name="Process">

   <xsl:call-template name="RPM"/>

	<SMStatus>0</SMStatus>
</xsl:template>

<xsl:template name="RPM">
    <xsl:for-each select=" Label ">
               <xsl:variable name="Fld1" select="substring-before(.,'=+=')"/>
			   <xsl:variable name="Pub11" select="substring-after(.,'=+=')"/>
			   <xsl:variable name="Pub1" select="substring-before($Pub11,'=+=')"/>
			   <xsl:variable name="Pub22" select="substring-after($Pub11,'=+=')"/>
			   <xsl:variable name="Pub2" select="substring-before($Pub22,'=+=')"/>
			   <xsl:variable name="Pub33" select="substring-after($Pub22,'=+=')"/>
			   <xsl:variable name="Pub3" select="substring-before($Pub33,'=+=')"/>
			   <xsl:variable name="Pub44" select="substring-after($Pub33,'=+=')"/>
			   <xsl:variable name="Pub4" select="substring-before($Pub44,'=+=')"/>
			   <xsl:variable name="Pub5" select="substring-after($Pub44,'=+=')"/>
			   
			   
			   <INSTALLED >
				   <Name displayname="RPM Name" type="string" ><xsl:value-of select="$Fld1"/></Name>
				   <Publisher displayname="Publisher" type="string" >
				   <xsl:value-of select="$Pub1"/>
				   </Publisher>
				   <Size  displayname="Size" type="string"><xsl:value-of select="$Pub2"/></Size>
				   <InstallDate displayname="Install Date" type="string" >
				   <xsl:value-of select="$Pub3"/>
				   </InstallDate>
				   <URLInfoAbout displayname="URL Info About" type="string" ><xsl:value-of select="$Pub4"/></URLInfoAbout>
				   <Description displayname="Description" type="string" ><xsl:value-of select="$Pub5"/></Description>
				   
			   </INSTALLED >

    </xsl:for-each>
</xsl:template>

</xsl:stylesheet>
