<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:output method="xml" />
<xsl:strip-space elements="*"/>
<xsl:template match="/osda">
	<osda>
		   <xsl:choose>
		   			<xsl:when test="//SMStatus = 0">
						<xsl:call-template name="Process" />
					</xsl:when>
					<xsl:when test = "//SMStatus &lt; 1">
						<xsl:call-template name="NoSource" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="NoSource" />
					</xsl:otherwise>
			</xsl:choose>
	</osda>
</xsl:template>

<xsl:template name="NoSource">
  <SMStatus>-1</SMStatus>
</xsl:template>

<xsl:template name="Process">

   <xsl:variable name="Eth0"><xsl:value-of select="Label[contains(@hint,'vmnic0')]/@lineno "/></xsl:variable> 
   <xsl:variable name="Eth1"><xsl:value-of select="Label[contains(@hint,'vmnic1')]/@lineno"/></xsl:variable> 
   <xsl:variable name="Eth2"><xsl:value-of select="Label[contains(@hint,'vmnic2')]/@lineno"/></xsl:variable> 
   <xsl:variable name="Eth3"><xsl:value-of select="Label[contains(@hint,'vmnic3')]/@lineno"/></xsl:variable> 
   <xsl:variable name="Eth4"><xsl:value-of select="Label[contains(@hint,'vmnic4')]/@lineno"/></xsl:variable> 
   <xsl:variable name="Eth5"><xsl:value-of select="Label[contains(@hint,'vmnic5')]/@lineno"/></xsl:variable> 
   <xsl:variable name="Eth6"><xsl:value-of select="Label[contains(@hint,'vmnic6')]/@lineno"/></xsl:variable> 
   <xsl:variable name="Eth7"><xsl:value-of select="Label[contains(@hint,'vmnic7')]/@lineno"/></xsl:variable> 
   
   <xsl:variable name="LoopBack"><xsl:value-of select="Label[@hint= 'lo']/@lineno  "/></xsl:variable> 
   <xsl:variable name="SitPos"><xsl:value-of select="Label[contains(@hint,'vswif')]/@lineno "/></xsl:variable> 
   <xsl:variable name="Resolv"><xsl:value-of select="Label[contains(@section,'resolv.conf')]/@lineno "/></xsl:variable> 
   <xsl:variable name="Hosts"><xsl:value-of select="Label[contains(@section,'hosts')]/@lineno "/></xsl:variable> 
   <!-- this would be the boundary in the etc host between normal and IPv6 -->
   <xsl:variable name="IPV6"><xsl:value-of select="Label[contains(@section,'hosts') and contains(@hint,'::') ]/@lineno "/></xsl:variable> 
   
   <!--coded to support 3 NICS at 8 lines per do we need 4? -->
	<xsl:if test="string-length($Eth0) &gt; 0">
	     <xsl:variable name="Stop0">
		  <xsl:choose>
				<xsl:when test="string-length($Eth1) &gt; 0">
				  <xsl:value-of select="number($Eth1)"/>
				</xsl:when>
				<xsl:otherwise>
				 <xsl:value-of select="number($LoopBack)"/>
				</xsl:otherwise>
			</xsl:choose>
	     </xsl:variable>
		 <xsl:call-template name="NICS">
			 <xsl:with-param name="Start" select="$Eth0"/>
			  <xsl:with-param name="Stop" select="number($Stop0)"/>
			</xsl:call-template>
    </xsl:if>
    <xsl:if test="string-length($Eth1) &gt; 0">
	     <xsl:variable name="Stop1">
		  <xsl:choose>
				<xsl:when test="string-length($Eth2) &gt; 0">
				  <xsl:value-of select="number($Eth2)"/>
				</xsl:when>
				<xsl:otherwise>
				 <xsl:value-of select="number($LoopBack)"/>
				</xsl:otherwise>
			</xsl:choose>
	     </xsl:variable>
		   <xsl:call-template name="NICS">
				 <xsl:with-param name="Start" select="number($Eth1)"/>
			     <xsl:with-param name="Stop" select="number($Stop1)"/>
			</xsl:call-template>
	</xsl:if>								
	<xsl:if test="string-length($Eth2) &gt; 0">
	     <xsl:variable name="Stop2">
		  <xsl:choose>
				<xsl:when test="string-length($Eth3) &gt; 0">
				  <xsl:value-of select="number($Eth3)"/>
				</xsl:when>
				<xsl:otherwise>
				 <xsl:value-of select="number($LoopBack)"/>
				</xsl:otherwise>
			</xsl:choose>
	     </xsl:variable>
		   <xsl:call-template name="NICS">
					  <xsl:with-param name="Start" select="number($Eth2)"/>
					  <xsl:with-param name="Stop" select="number($Stop2)"/>
			</xsl:call-template>
	</xsl:if>						
	<xsl:if test="string-length($Eth3) &gt; 0">
	     <xsl:variable name="Stop3">
		  <xsl:choose>
				<xsl:when test="string-length($Eth4) &gt; 0">
				  <xsl:value-of select="number($Eth4)"/>
				</xsl:when>
				<xsl:otherwise>
				 <xsl:value-of select="number($LoopBack)"/>
				</xsl:otherwise>
			</xsl:choose>
	     </xsl:variable>
		   <xsl:call-template name="NICS">
					  <xsl:with-param name="Start" select="number($Eth3)"/>
					  <xsl:with-param name="Stop" select="number($Stop3)"/>
			</xsl:call-template>
	</xsl:if>						
	<xsl:if test="string-length($Eth4) &gt; 0">
	     <xsl:variable name="Stop4">
		  <xsl:choose>
				<xsl:when test="string-length($Eth5) &gt; 0">
				  <xsl:value-of select="number($Eth5)"/>
				</xsl:when>
				<xsl:otherwise>
				 <xsl:value-of select="number($LoopBack)"/>
				</xsl:otherwise>
			</xsl:choose>
	     </xsl:variable>
		   <xsl:call-template name="NICS">
					  <xsl:with-param name="Start" select="number($Eth4)"/>
					  <xsl:with-param name="Stop" select="number($Stop4)"/>
			</xsl:call-template>
	</xsl:if>						
	<xsl:if test="string-length($Eth5) &gt; 0">
	     <xsl:variable name="Stop5">
		  <xsl:choose>
				<xsl:when test="string-length($Eth6) &gt; 0">
				  <xsl:value-of select="number($Eth6)"/>
				</xsl:when>
				<xsl:otherwise>
				 <xsl:value-of select="number($LoopBack)"/>
				</xsl:otherwise>
			</xsl:choose>
	     </xsl:variable>
		   <xsl:call-template name="NICS">
					  <xsl:with-param name="Start" select="number($Eth5)"/>
					  <xsl:with-param name="Stop" select="number($Stop5)"/>
			</xsl:call-template>
	</xsl:if>						
	<xsl:if test="string-length($Eth6) &gt; 0">
	     <xsl:variable name="Stop6">
		  <xsl:choose>
				<xsl:when test="string-length($Eth7) &gt; 0">
				  <xsl:value-of select="number($Eth7)"/>
				</xsl:when>
				<xsl:otherwise>
				 <xsl:value-of select="number($LoopBack)"/>
				</xsl:otherwise>
			</xsl:choose>
	     </xsl:variable>
		   <xsl:call-template name="NICS">
					  <xsl:with-param name="Start" select="number($Eth6)"/>
					  <xsl:with-param name="Stop" select="number($Stop6)"/>
			</xsl:call-template>
	</xsl:if>						
	<xsl:if test="string-length($Eth7) &gt; 0">
		   <xsl:call-template name="NICS">
					  <xsl:with-param name="Start" select="number($Eth7)"/>
					  <xsl:with-param name="Stop" select="number($LoopBack)"/>
			</xsl:call-template>
	</xsl:if>						
	
	  <!-- now get loop and sit -->
			   <xsl:call-template name="NICS">
						  <xsl:with-param name="Start" select="$LoopBack"/>
						  <xsl:with-param name="Stop" select="$SitPos"/>
				</xsl:call-template>
				
			   <xsl:call-template name="NICS">
						  <xsl:with-param name="Start" select="$SitPos"/>
						  <xsl:with-param name="Stop" select="$Resolv"/>
				</xsl:call-template>
	  
	  <!-- now get etc/resolv and etc/hosts -->
	  
			   <xsl:call-template name="Resolve">
						  <xsl:with-param name="Start" select="$Resolv"/>
						  <xsl:with-param name="Stop" select="$Hosts"/>
				</xsl:call-template>
	  
			   <xsl:call-template name="Hosts">
						  <xsl:with-param name="Start" select="$Hosts"/>
						  <xsl:with-param name="Stop" select="$IPV6"/>
						  <xsl:with-param name="Fmt">Normal</xsl:with-param>
				</xsl:call-template>
				
			   <xsl:call-template name="Hosts">
						  <xsl:with-param name="Start" select="$IPV6"/>
						  <xsl:with-param name="Stop" select="number($IPV6)+20"/>
						  <xsl:with-param name="Fmt">IPV6</xsl:with-param>
				</xsl:call-template>
				
			<SMStatus>0</SMStatus>
</xsl:template>
<!-- end processing logic -->

<!-- begin template definitions --> 

<xsl:template name="Resolve">
<xsl:param name="Start"/>
<xsl:param name="Stop"/>
<NETRESOLV>
   <xsl:for-each select="Label[@lineno &gt;= number($Start) and @lineno &lt; number($Stop)]">
		<xsl:variable name="Fld1" select="substring-before(normalize-space(node()),' ')"/>
		<xsl:variable name="Fld2" select="substring-after(normalize-space(.),' ')"/>

            <xsl:if test="contains($Fld1,'nameserver')">
					<NameServer displayname="Name Server" type="string"><xsl:value-of select="$Fld2"/></NameServer>
			</xsl:if>
            <xsl:if test="contains($Fld1,'domain')">
					<Domain displayname="Domain" type="string"><xsl:value-of select="$Fld2"/></Domain>
			</xsl:if>
            <xsl:if test="contains($Fld1,'search')">
					<Search displayname="Search" type="string"><xsl:value-of select="$Fld2"/></Search>
			</xsl:if>
            <xsl:if test="contains($Fld1,'sortlist')">
					<SortList displayname="Sort List" type="string"><xsl:value-of select="$Fld2"/></SortList>
			</xsl:if>
            <xsl:if test="contains($Fld1,'options')">
					<Options displayname="Options" type="string"><xsl:value-of select="$Fld2"/></Options>
			</xsl:if>
   </xsl:for-each>
</NETRESOLV>
</xsl:template>

<xsl:template name="Hosts">
<xsl:param name="Start"/>
<xsl:param name="Stop"/>
<xsl:param name="Fmt"/>
<NETHOSTS type="{$Fmt}">
   <xsl:for-each select="Label[@lineno &gt;= number($Start) and @lineno &lt; number($Stop)]">
		<xsl:variable name="Fld1" select="substring-before(normalize-space(node()),' ')"/>
		<xsl:variable name="Fld2" select="substring-after(normalize-space(.),' ')"/>
        <xsl:if test="contains(node(),' ') ">
            <xsl:if test="contains($Fmt,'IPV6')">
				<Item displayname="IPV6 Port or IP Address" type="string" address="{$Fld1}"><xsl:value-of select="$Fld2"/></Item>
			</xsl:if>
            <xsl:if test="contains($Fmt,'Normal')">
				<Item displayname="IP Address" type="string" address="{$Fld1}"><xsl:value-of select="$Fld2"/></Item>
			</xsl:if>
			</xsl:if>
   </xsl:for-each>
</NETHOSTS>
</xsl:template>

<xsl:template name="NICS">
   <xsl:param name="Start"/>
   <xsl:param name="Stop"/>
<!--first get the adapter info  -->   
   
	<NETADPLISTHW  type="string" description="Network Adapter List" required="true" >
   <xsl:for-each select="Label[@lineno = number($Start)]">
								<!-- Adapter info -->
								<xsl:call-template name="Adapter">
								<xsl:with-param name="Hint" select="@hint" />
								</xsl:call-template >
   </xsl:for-each>
   <!-- now skip 1 line down and get Config-->
  <NETADPCONFIG type="string" description="Network Adapter Configuration List" required="true">
    <xsl:for-each select="Label[@lineno &gt; number($Start) and @lineno &lt;= number($Start)+3]">

	                   <xsl:choose>
										<xsl:when test="contains(@hint,'inet') ">
														<xsl:call-template name="INET">
														<xsl:with-param name="FirstWord" select="@hint" />
											</xsl:call-template >
	 								    </xsl:when>
   										<xsl:when test="contains(@hint, 'UP') or contains(@hint,'NOARP') ">
														<xsl:call-template name="Up"/>
									    </xsl:when>
						</xsl:choose>   	
	</xsl:for-each>
	</NETADPCONFIG>
	
	<NETPROTOCOL  type="string" description="Network Protocol List" required="true">
    <xsl:for-each select="Label[@lineno &gt;= number($Start)+3 and @lineno &lt;= number($Stop)]">
	                   <xsl:choose>
										<xsl:when test="contains(@hint,'RX') ">
											<xsl:choose>
																<xsl:when test="contains(node(),'packets' )">
																	<xsl:call-template name="Rx_packet"/>
																</xsl:when>
																<xsl:when test="contains(node(),'bytes' )">
																	<xsl:call-template name="Rx_byte"/>
																</xsl:when>
											</xsl:choose>
										</xsl:when>
										<xsl:when test="contains(@hint,'TX') ">
											<xsl:call-template name="Tx_packet"/>
										</xsl:when>
										<xsl:when test="contains(@hint, 'collisions') ">
											<xsl:call-template name="Collision">
											<xsl:with-param name="FirstWord" select="@hint" />
											</xsl:call-template >
										</xsl:when>
										<xsl:when test="contains(@hint, 'Interrupt') ">
											<xsl:call-template name="IntMem" />
										</xsl:when>
									
					</xsl:choose>
    </xsl:for-each>
    </NETPROTOCOL>
    </NETADPLISTHW>
</xsl:template>


<xsl:template name="Up">
		<xsl:variable name="Fld1" select="substring-before(normalize-space(node()),' ')"/>
		<xsl:variable name="Fld2" select="substring-after(normalize-space(.),' ')"/>
		<xsl:variable name="Fld3" select="substring-after($Fld2, ' ')"/>
		<xsl:variable name="Fld4" select="normalize-space(substring-after($Fld3,':'))"/>
		<xsl:variable name="Fld5" select="substring-after($Fld4,' ')"/>
		<xsl:variable name="Fld6" select="normalize-space(substring-after($Fld5,':'))"/>

			<Status displayname="Status" type="string"><xsl:value-of select="$Fld1"/>
			</Status>
			<StatusChar displayname="Status Characteristics" type="string"><xsl:value-of select="substring-before($Fld2,'MTU')"/>
			</StatusChar>
			<MTU displayname="MTU" type="int"><xsl:value-of select="substring-before(substring-after($Fld2,'MTU:'),' ')"/></MTU>
			<Metric displayname="Metric" type="int"><xsl:value-of select="substring-after($Fld2,'Metric:') "/></Metric>

</xsl:template>

<xsl:template name="Rx_packet">
		<xsl:variable name="Fld1" select="substring-after(normalize-space(node()),':')"/>
		<xsl:variable name="Fld2" select="substring-after($Fld1,':')"/>
		<xsl:variable name="Fld3" select="substring-after($Fld2, ':')"/>
		<xsl:variable name="Fld4" select="substring-after($Fld3,':')"/>
		<xsl:variable name="Fld5" select="substring-after($Fld4,':')"/>

			<RXPackets displayname="RX Packets" type="int"><xsl:value-of select="substring-before($Fld1,' ')"/></RXPackets>
			<RXErrors displayname="RX Errors" type="int"><xsl:value-of select="substring-before($Fld2,' ')"/></RXErrors>
			<RXDropped displayname="RX Dropped" type="int"><xsl:value-of select="substring-before($Fld3,' ')"/></RXDropped>
			<RXOverruns displayname="RX Overruns" type="int"><xsl:value-of select="substring-before($Fld4,' ')"/></RXOverruns>
			<RXFrame displayname="RX Frame" type="int"><xsl:value-of select="$Fld5"/></RXFrame>

</xsl:template>

<xsl:template name="Tx_packet">
		<xsl:variable name="Fld1" select="substring-after(normalize-space(node()),':')"/>
		<xsl:variable name="Fld2" select="substring-after($Fld1,':')"/>
		<xsl:variable name="Fld3" select="substring-after($Fld2, ':')"/>
		<xsl:variable name="Fld4" select="substring-after($Fld3,':')"/>
		<xsl:variable name="Fld5" select="substring-after($Fld4,':')"/>

			<TXPackets displayname="TX Packets" type="int"><xsl:value-of select="substring-before($Fld1,' ')"/></TXPackets>
			<TXErrors displayname="TX Errors" type="int"><xsl:value-of select="substring-before($Fld2,' ')"/></TXErrors>
			<TXDropped displayname="TX Dropped" type="int"><xsl:value-of select="substring-before($Fld3,' ')"/></TXDropped>
			<TXOverruns displayname="TX Overruns" type="int"><xsl:value-of select="substring-before($Fld4,' ')"/></TXOverruns>
			<TXCarrier displayname="TX Carrier" type="int"><xsl:value-of select="$Fld5"/></TXCarrier>

</xsl:template>


<xsl:template name="Rx_byte">
		<xsl:variable name="Fld1" select="normalize-space(substring-after(node(),':'))"/>
		<xsl:variable name="Fld2" select="substring-after($Fld1,':')"/>

			<RXbytes displayname="RX bytes" type="int"><xsl:value-of select="substring-before($Fld1,'TX')"/></RXbytes>
			<TXbytes displayname="TX bytes" type="int"><xsl:value-of select="$Fld2"/></TXbytes>

</xsl:template>

<xsl:template name="Collision">
		<xsl:variable name="Fld1" select="substring-after(normalize-space(node()),':')"/>
		<xsl:variable name="Fld2" select="substring-after($Fld1,':')"/>
		<xsl:variable name="Fld3" select="substring-after($Fld2, ':')"/>
		<xsl:variable name="Fld4" select="substring-after($Fld3,':')"/>
		<xsl:variable name="Fld5" select="substring-after($Fld4,':')"/>
		
			<Collisions displayname="Collisions" type="int"><xsl:value-of select="substring-before($Fld1,' ')"/></Collisions>
			<TxQueueLen displayname="TxQueueLen" type="int"><xsl:value-of select="$Fld2"/></TxQueueLen>

</xsl:template>

<xsl:template name="IntMem">
		<xsl:variable name="Fld1" select="substring-after(normalize-space(node()),':')"/>
		<xsl:variable name="Fld2" select="substring-after($Fld1,':')"/>
		<xsl:variable name="Fld3" select="substring-after($Fld2, ':')"/>
		<xsl:variable name="Fld4" select="substring-after($Fld3,':')"/>
		<xsl:variable name="Fld5" select="substring-after($Fld4,':')"/>
		
			 <xsl:choose>
					<xsl:when test="string-length($Fld2) = 0">
						<Interrupt displayname=" Interrupt" type="int"><xsl:value-of select="$Fld1"/></Interrupt>
						<MemoryAddress displayname="Memory Address" type="string">N/A</MemoryAddress>
					</xsl:when>
					<xsl:otherwise>
						<Interrupt displayname=" Interrupt" type="int"><xsl:value-of select="substring-before($Fld1,' ')"/></Interrupt>
						<MemoryAddress displayname="Memory Address" type="string"><xsl:value-of select="$Fld2"/></MemoryAddress>
					</xsl:otherwise>
				</xsl:choose>

</xsl:template>


<xsl:template name="INET">
<xsl:param name="FirstWord" />
  		<xsl:variable name="Fld1" select="substring-after(normalize-space(node()),':')"/>
	    <xsl:variable name="Fld2" select="substring-after($Fld1,' ')"/>
	    <xsl:variable name="Fld3" select="substring-after($Fld2,' ')"/>
	    
	  <xsl:choose>
				<xsl:when test="$FirstWord ='inet6' ">
					<Inet6IPAddress displayname="inet6 IPAddress" type="string"><xsl:value-of select="substring-before(substring-after(node(),'addr:'),'Scope')"/></Inet6IPAddress>
					<Scope displayname="Scope"  type="string"><xsl:value-of select="substring-after($Fld3,':')"/></Scope>
				</xsl:when>
				<xsl:when test="$FirstWord = 'inet' ">
					<InetIPAddress displayname="inet IPAddress" type="string" ><xsl:value-of select="substring-before($Fld1, ' ')"/></InetIPAddress>
					<BroadCast displayname="Broadcast" type="string" ><xsl:value-of select="substring-before(substring-after($Fld2,':'),' ')"/></BroadCast>
					<SubnetMask displayname="Subnet Mask" type="string" ><xsl:value-of select="substring-after($Fld3,':')"/></SubnetMask>
					</xsl:when>
			</xsl:choose>
</xsl:template>

<xsl:template name="Adapter">
<xsl:param name="Hint" />
					<Name displayname="Adapter Name" type="string"><xsl:value-of select="$Hint"/></Name>
					<AdapterType displayname="Adapter Type" type="string"><xsl:value-of select="substring-before(substring-after(.,'encap:'),' ')" /></AdapterType>
					<MAC_Address displayname=" MAC Address" type="string"><xsl:value-of select="substring-after(.,'HWaddr')"/></MAC_Address>
</xsl:template>


</xsl:stylesheet>
