<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:output method="xml" />
<xsl:strip-space elements="*"/>



<xsl:template match="/osda">
	<osda>
		   <xsl:choose>
		   			<xsl:when test="//SMStatus = 0">
						<xsl:call-template name="Process" />
					</xsl:when>
					<xsl:when test = "//SMStatus &lt; 1">
						<xsl:call-template name="NoSource" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="NoSource" />
					</xsl:otherwise>
			</xsl:choose>
	</osda>
</xsl:template>

<xsl:template name="NoSource">
  <SMStatus>-1</SMStatus>
</xsl:template>

<xsl:template name="Process">
 <MEMUSAGE>
   <xsl:call-template name="Mem"/>
</MEMUSAGE>
<SMStatus>0</SMStatus>
	
</xsl:template>

<xsl:template name="Mem">
    <xsl:for-each select=" Label">
		<xsl:if test="contains(@section,'proc/meminfo')">
			<xsl:if test=" substring(@hint,1,3)  != '---' ">
				<xsl:choose>
					<xsl:when test="@hint = 'MemTotal:' ">
						<MemTotal displayname="{substring-before(@hint,':')}" type="string" ><xsl:value-of select="normalize-space(substring-after(.,':'))"/>
						</MemTotal>
					</xsl:when>
					<xsl:when test="@hint = 'MemFree:' ">
						<MemFree displayname="{substring-before(@hint,':')}" type="string" ><xsl:value-of select="normalize-space(substring-after(.,':'))"/>
						</MemFree>
					</xsl:when>
					<xsl:when test="@hint = 'MemShared:' ">
						<MemShared displayname="{substring-before(@hint,':')}" type="string" ><xsl:value-of select="normalize-space(substring-after(.,':'))"/>
						</MemShared>
					</xsl:when>
					<xsl:when test="@hint = 'Buffers:' ">
						<Buffers displayname="{substring-before(@hint,':')}" type="string" ><xsl:value-of select="normalize-space(substring-after(.,':'))"/>
						</Buffers>
					</xsl:when>
					<xsl:when test="@hint = 'Cached:' ">
						<Cached displayname="{substring-before(@hint,':')}" type="string" ><xsl:value-of select="normalize-space(substring-after(.,':'))"/>
						</Cached>
					</xsl:when>
					<xsl:when test="@hint = 'SwapCached:' ">
						<SwapCached displayname="{substring-before(@hint,':')}" type="string" ><xsl:value-of select="normalize-space(substring-after(.,':'))"/>
						</SwapCached>
					</xsl:when>
					<xsl:when test="@hint = 'Active:' ">
						<Active displayname="{substring-before(@hint,':')}" type="string" ><xsl:value-of select="normalize-space(substring-after(.,':'))"/>
						</Active>
					</xsl:when>
					<xsl:when test="@hint = 'ActiveAnon:' ">
						<ActiveAnon displayname="{substring-before(@hint,':')}" type="string" ><xsl:value-of select="normalize-space(substring-after(.,':'))"/>
						</ActiveAnon>
					</xsl:when>
					<xsl:when test="@hint = 'ActiveCache:' ">
						<ActiveCache displayname="{substring-before(@hint,':')}" type="string" ><xsl:value-of select="normalize-space(substring-after(.,':'))"/>
						</ActiveCache>
					</xsl:when>
					<xsl:when test="@hint = 'Inact_dirty:' ">
						<Inact_dirty displayname="{substring-before(@hint,':')}" type="string" ><xsl:value-of select="normalize-space(substring-after(.,':'))"/>
						</Inact_dirty>
					</xsl:when>	
					<xsl:when test="@hint = 'Inact_laundry:' ">
						<Inact_laundry displayname="{substring-before(@hint,':')}" type="string" ><xsl:value-of select="normalize-space(substring-after(.,':'))"/>
						</Inact_laundry>
					</xsl:when>		
					<xsl:when test="@hint = 'Inact_clean:' ">
						<Inact_clean displayname="{substring-before(@hint,':')}" type="string" ><xsl:value-of select="normalize-space(substring-after(.,':'))"/>
						</Inact_clean>
					</xsl:when>	
					<xsl:when test="@hint = 'Inact_target:' ">
						<Inact_target displayname="{substring-before(@hint,':')}" type="string" ><xsl:value-of select="normalize-space(substring-after(.,':'))"/>
						</Inact_target>
					</xsl:when>																															
					<xsl:when test="@hint = 'Inactive:' ">
						<Inactive displayname="{substring-before(@hint,':')}" type="string" ><xsl:value-of select="normalize-space(substring-after(.,':'))"/>
						</Inactive>
					</xsl:when>
					<xsl:when test="@hint = 'HighTotal:' ">
						<HighTotal displayname="{substring-before(@hint,':')}" type="string" ><xsl:value-of select="normalize-space(substring-after(.,':'))"/>
						</HighTotal>
					</xsl:when>
					<xsl:when test="@hint = 'HighFree:' ">
						<HighFree displayname="{substring-before(@hint,':')}" type="string" ><xsl:value-of select="normalize-space(substring-after(.,':'))"/>
						</HighFree>
					</xsl:when>
					<xsl:when test="@hint = 'LowTotal:' ">
						<LowTotal displayname="{substring-before(@hint,':')}" type="string" ><xsl:value-of select="normalize-space(substring-after(.,':'))"/>
						</LowTotal>
					</xsl:when>
					<xsl:when test="@hint = 'LowFree:' ">
						<LowFree displayname="{substring-before(@hint,':')}" type="string" ><xsl:value-of select="normalize-space(substring-after(.,':'))"/>
						</LowFree>
					</xsl:when>
					<xsl:when test="@hint = 'SwapTotal:' ">
						<SwapTotal displayname="{substring-before(@hint,':')}" type="string" ><xsl:value-of select="normalize-space(substring-after(.,':'))"/>
						</SwapTotal>
					</xsl:when>
					<xsl:when test="@hint = 'SwapFree:' ">
						<SwapFree displayname="{substring-before(@hint,':')}" type="string" ><xsl:value-of select="normalize-space(substring-after(.,':'))"/>
						</SwapFree>
					</xsl:when>			
					<xsl:when test="@hint = 'Dirty:' ">
						<Dirty displayname="{substring-before(@hint,':')}" type="string" ><xsl:value-of select="normalize-space(substring-after(.,':'))"/>
						</Dirty>
					</xsl:when>
					<xsl:when test="@hint = 'Writeback:' ">
						<Writeback displayname="{substring-before(@hint,':')}" type="string" ><xsl:value-of select="normalize-space(substring-after(.,':'))"/>
						</Writeback>
					</xsl:when>
					<xsl:when test="@hint = 'AnonPages:' ">
						<AnonPages displayname="{substring-before(@hint,':')}" type="string" ><xsl:value-of select="normalize-space(substring-after(.,':'))"/>
						</AnonPages>
					</xsl:when>
					<xsl:when test="@hint ='Mapped:' ">
						<Mapped displayname="{substring-before(@hint,':')}" type="string" ><xsl:value-of select="normalize-space(substring-after(.,':'))"/>
						</Mapped>
					</xsl:when>
					<xsl:when test="@hint = 'Slab:' ">
						<Slab displayname="{substring-before(@hint,':')}" type="string" ><xsl:value-of select="normalize-space(substring-after(.,':'))"/>
						</Slab>
					</xsl:when>
					<xsl:when test="@hint = 'SReclaimable:' ">
						<SReclaimable displayname="{substring-before(@hint,':')}" type="string" ><xsl:value-of select="normalize-space(substring-after(.,':'))"/>
						</SReclaimable>
					</xsl:when>
					<xsl:when test="@hint = 'SUnreclaim:' ">
						<SUnreclaim displayname="{substring-before(@hint,':')}" type="string" ><xsl:value-of select="normalize-space(substring-after(.,':'))"/>
						</SUnreclaim>
					</xsl:when>
					<xsl:when test="@hint = 'CommitLimit:' ">
						<CommitLimit displayname="{substring-before(@hint,':')}" type="string" ><xsl:value-of select="normalize-space(substring-after(.,':'))"/>
						</CommitLimit>
					</xsl:when>
					<xsl:when test="@hint = 'Committed_AS:' ">
						<Committed_AS displayname="{substring-before(@hint,':')}" type="string" ><xsl:value-of select="normalize-space(substring-after(.,':'))"/>
						</Committed_AS>
					</xsl:when>
					<xsl:when test="@hint = 'PageTables:' ">
						<PageTables displayname="{substring-before(@hint,':')}" type="string" ><xsl:value-of select="normalize-space(substring-after(.,':'))"/>
						</PageTables>
					</xsl:when>
					<xsl:when test="@hint = 'NFS_Unstable:' ">
						<NFS_Unstable displayname="{substring-before(@hint,':')}" type="string" ><xsl:value-of select="normalize-space(substring-after(.,':'))"/>
						</NFS_Unstable>
					</xsl:when>
					<xsl:when test="@hint = 'Bounce:' ">
						<Bounce displayname="{substring-before(@hint,':')}" type="string" ><xsl:value-of select="normalize-space(substring-after(.,':'))"/>
						</Bounce>
					</xsl:when>
					<xsl:when test="@hint = 'WritebackTmp:' ">
						<WritebackTmp displayname="{substring-before(@hint,':')}" type="string" ><xsl:value-of select="normalize-space(substring-after(.,':'))"/>
						</WritebackTmp>
					</xsl:when>
					<xsl:when test="@hint = 'VmallocTotal:' ">
						<VmallocTotal displayname="{substring-before(@hint,':')}" type="string" ><xsl:value-of select="normalize-space(substring-after(.,':'))"/>
						</VmallocTotal>
					</xsl:when>
					<xsl:when test="@hint = 'VmallocUsed:' ">
						<VmallocUsed displayname="{substring-before(@hint,':')}" type="string" ><xsl:value-of select="normalize-space(substring-after(.,':'))"/>
						</VmallocUsed>
					</xsl:when>
					<xsl:when test="@hint = 'VmallocChunk:' ">
						<VmallocChunk displayname="{substring-before(@hint,':')}" type="string" ><xsl:value-of select="normalize-space(substring-after(.,':'))"/>
						</VmallocChunk>
					</xsl:when>
					<xsl:when test="@hint = 'HugePages_Total:' ">
						<HugePages_Total displayname="{substring-before(@hint,':')}" type="string" ><xsl:value-of select="normalize-space(substring-after(.,':'))"/>
						</HugePages_Total>
					</xsl:when>
					<xsl:when test="@hint = 'HugePages_Free:' ">
						<HugePages_Free displayname="{substring-before(@hint,':')}" type="string" ><xsl:value-of select="normalize-space(substring-after(.,':'))"/>
						</HugePages_Free>
					</xsl:when>
					<xsl:when test="@hint = 'HugePages_Rsvd:' ">
						<HugePages_Rsvd displayname="{substring-before(@hint,':')}" type="string" ><xsl:value-of select="normalize-space(substring-after(.,':'))"/>
						</HugePages_Rsvd>
					</xsl:when>
					<xsl:when test="@hint = 'HugePages_Surp:' ">
						<HugePages_Surp displayname="{substring-before(@hint,':')}" type="string" ><xsl:value-of select="normalize-space(substring-after(.,':'))"/>
						</HugePages_Surp>
					</xsl:when>
					<xsl:when test="@hint = 'Hugepagesize:' ">
						<Hugepagesize displayname="{substring-before(@hint,':')}" type="string" ><xsl:value-of select="normalize-space(substring-after(.,':'))"/>
						</Hugepagesize>
					</xsl:when>
					<xsl:when test="@hint = 'DirectMap4k:' ">
						<DirectMap4k displayname="{substring-before(@hint,':')}" type="string" ><xsl:value-of select="normalize-space(substring-after(.,':'))"/>
						</DirectMap4k>
					</xsl:when>
					<xsl:when test="@hint = 'DirectMap2M:' ">
						<DirectMap2M displayname="{substring-before(@hint,':')}" type="string" ><xsl:value-of select="normalize-space(substring-after(.,':'))"/>
						</DirectMap2M>
					</xsl:when>
					<xsl:when test="@hint = 'MachineMem:' ">
						<MachineMem displayname="{substring-before(@hint,':')}" type="string" ><xsl:value-of select="normalize-space(substring-after(.,':'))"/>
						</MachineMem>
					</xsl:when>					
				</xsl:choose>
				</xsl:if>
		</xsl:if>
    </xsl:for-each>
</xsl:template>


</xsl:stylesheet>
