# dell-sysreport.sh

export PATH=$PATH:"/sbin:/usr/sbin:/bin:/usr/bin:/usr/X11R6/bin"

getpartinfo() {
  # Get fdisk -l output from all disks/partitionable raid devices from /proc/partitions
  raiddevs=`/bin/cat /proc/partitions | /bin/egrep -v "^major|^$" | /bin/awk '{print $4}' | /bin/grep \/ | /bin/egrep -v "p[0123456789]$"`
  disks=`/bin/cat /proc/partitions | /bin/egrep -v "^major|^$" | /bin/awk '{print $4}' | /bin/grep -v / | /bin/egrep -v "[0123456789]$"`
  echo "fdisk -l output"
  for d in $raiddevs $disks ; do
    echo "<----  Disk: /dev/${d}  ---->"
    echo ""
    /sbin/fdisk -l /dev/${d} 2>&1
    echo ""
    echo "<----    END     ---->"
    done
}

Timeout()
{
	pid=`ps -A|grep $1`
	if [ "$pid" != "" ]; then
		sleep $2
	fi
	pid=`ps -A|grep $1`
	if [ "$pid" != "" ]; then
		kill -9 $1
	fi
}

getpciinfo() {
( echo "lspci"
  echo
  /sbin/lspci
  echo
  echo "lspci -n"
  echo
  /sbin/lspci -n
  echo
  echo "lspci -nv"
  echo
  /sbin/lspci -nv
  echo 
  echo "lspci -nvv"
  echo
  /sbin/lspci -nvv ) 2>&1
}

getiptableinfo() {
iptablesPath=$1
( echo "iptables -nvL"
  echo
  $iptablesPath -nvL
  echo
  echo "iptables -t filter -nvL"
  echo
  $iptablesPath -t filter -nvL
  echo
  echo "iptables -t mangle -nvL"
  echo
  $iptablesPath -t mangle -nvL
  echo 
  echo "iptables -t nat -nvL"
  echo
  $iptablesPath -t nat -nvL ) 2>&1
}

catiffile() {
  if [ -d $1 ]; then
#Added --dereference to follow symlinks across filesystems even if DSET is installed on a central share
    if /bin/cp --parents -R --dereference $1 $ROOT >>$LOG_FILE 2>&1
    then
      return 1
    fi
  fi
  if [ -f $1 ]; then
    if /bin/cp --parents --dereference $1 $ROOT >>$LOG_FILE 2>&1
    then
      return 1
    fi
  fi
  return 0
}

catifexec() {
  if [ -x $1 ]; then
   if [ -f /bin/basename ]; then
    if $* > $ROOT/`/bin/basename $1` 2>&1; then
      return 1
    fi
   elif [ -f /usr/bin/basename ]; then
    if $* > $ROOT/`/usr/bin/basename $1` 2>&1; then
      return 1
    fi
   fi
  fi
  return 0
}

#reading system configuration and setting paths
readConfig() {
	if [ -z "$BOOTUP" ]; then
	  if [ -f /etc/sysconfig/init ]; then
		  . /etc/sysconfig/init
	  else
		# This all seem confusing? Look in /etc/sysconfig/init,
		# or in /usr/doc/initscripts-*/sysconfig.txt
		LOGLEVEL=1
	  fi
	fi
	echo $1
	if [ -z $REPORTPATH ]; then
	export REPORTPATH=/tmp/dset
	fi

	if [ -z $DSETLOG ]; then
		export DSETLOG=$REPORTPATH/log/DSET/main.log
	fi

	mkdir -p $REPORTPATH/log/DSET

	umask 0077

}

OMSAsetup() {
	if [ "$OMSAversion" != "" ]; then

			
		/opt/dell/srvadmin/bin/omreport system alertaction > $OMSAROOT/alertactions.txt 2>>$LOG_FILE 

		/opt/dell/srvadmin/bin/omreport system alertlog > $OMSAROOT/alertlog.txt 2>>$LOG_FILE

		/opt/dell/srvadmin/bin/omreport system cmdlog > $OMSAROOT/cmdlog.txt 2>>$LOG_FILE

		/opt/dell/srvadmin/bin/omreport system events > $OMSAROOT/snmpevents.txt 2>>$LOG_FILE

		/opt/dell/srvadmin/bin/omreport system pedestinations > $OMSAROOT/pedestinations.txt 2>>$LOG_FILE

		/opt/dell/srvadmin/bin/omreport system platformevents > $OMSAROOT/platformevents.txt 2>>$LOG_FILE

	fi
		

	# Now get various OMSA and OMSA install logs and misc. info

	mkdir -p $OMIROOT/oils $OMSAROOT/Instrumentation $OMSAROOT/DataEngine $DELLROOT/Diagnostics

	cp /etc/ominstal.db $OMIROOT/ >>$LOG_FILE 2>&1
	cp /etc/omreg.cfg $OMSAROOT/ >>$LOG_FILE 2>&1
	cp /etc/*.oil $OMIROOT/oils/ >>$LOG_FILE 2>&1
	cp /var/log/srvadmin* $OMIROOT/ >>$LOG_FILE 2>&1
	cp /etc/dellinst.cfg $OMSAROOT/ >>$LOG_FILE 2>&1
	cp $InstInstallLog $OMSAROOT/Instrumentation >>$LOG_FILE 2>&1
	cp $DengInstallLog $OMSAROOT/DataEngine >>$LOG_FILE 2>&1
	cp $DKSlog $OMSAROOT/Instrumentation/ >>$LOG_FILE 2>&1
	cp $DKSlog2 $OMSAROOT/Instrumentation/ >>$LOG_FILE 2>&1
	cp $OMSApath/etc/srvadmin-deng/ini/*.ini $OMSAROOT/DataEngine >>$LOG_FILE 2>&1
	cp $OMSApath/etc/srvadmin-isvc/ini/*.ini $OMSAROOT/Instrumentation >>$LOG_FILE 2>&1
	cp $OMSApath/omsa/log/*.* $OMSAROOT/Instrumentation >>$LOG_FILE 2>&1
	# if [ -e $OMSApath/oldiags/log/result.xml ]; then
	# 	cp $OMSApath/oldiags/log/*.xml $ROOT/Diagnostics #>>$LOG_FILE 2>&1
	# fi
	
	Line="OpenManage Server Administrator is not installed"
	if [ ! -f  /etc/omreg.cfg ]
	then
		echo "Omsa Not Found"
		echo $Line >$ROOT/omsa

	else 
	Line=`cat /etc/omreg.cfg |grep openmanage.omacore.installpath`
	InstallPath=`echo $Line | awk -F"=" '{print $2}'`
	Line=`cat /etc/omreg.cfg |grep openmanage.version`
	Version=`echo $Line | awk -F"=" '{print $2}'`
	echo "Dell OpenManage Server Administrator (OMSA) is installed, "  $Version > $ROOT/omsa
	echo "Path: " $InstallPath >> $ROOT/omsa
	echo "The following OMSA services are installed:" >>$ROOT/omsa
	InstalledRPMs=`rpm -qa | grep 'srvadmin-\|instsvc-'`
	for item in ${InstalledRPMs}
	do
	Data=`rpm -q --queryformat '      %{SUMMARY}\n' $item`
	echo $Data >> $ROOT/omsa
	done

	fi
}

getDiagnosticLogs() {
	# PEDiags always puts log files in /var/log/dell/diagnostics/log. So copy from there
	if [ -e /var/log/dell/diagnostics/log/result.xml ]; then
		cp /var/log/dell/diagnostics/log/*.xml $DELLROOT/Diagnostics >>$LOG_FILE 2>&1
		cp /var/log/dell/diagnostics/log/*.log $DELLROOT/Diagnostics >>$LOG_FILE 2>&1
	fi
}

# Get Server Update Utility support logs (SUU) and any Dell Update Pkg (DUP) logs found
getServerUpdate() {
	mkdir -p  $SUUROOT $DUPROOT

	cp $SUUlogs $SUUROOT/ >>$LOG_FILE 2>&1
	cp $DUPlogs $DUPROOT/ >>$LOG_FILE 2>&1
}


: '
getControllerInformation() {	
	mkdir -p "$RAIDCONTROLLER"
	ls /opt/dell/advdiags/dset/bin/ControllerTTY*.txt
	if test $? == 0; then
	    mv -f /opt/dell/advdiags/dset/bin/ControllerTTY*.txt "$RAIDCONTROLLER"/ 2>>$LOG_FILE
	else
		# Controllers page
		/opt/dell/srvadmin/bin/omreport storage controller > "$RAIDCONTROLLER/controller.txt" 2>>$LOG_FILE
		# Determine number of controllers in the system
		ControllerCount=`grep -c "^ID" "$RAIDCONTROLLER/controller.txt"`
		rm -f "$RAIDCONTROLLER/controller.txt" 2>>$LOG_FILE
		let "ControllerCount -= 1"  
 		ControllerNumber=0
        timeDate=`date +"%m%d"`
		# this is to remove any stale file if present before dumping the fresh set of logs.
		rm -rf /var/log/afa_$timeDate*
		rm -rf /var/log/lsi_$timeDate*
		while [ "$ControllerNumber" -le "$ControllerCount" ]
		do
		#  try to dump the controllers log
			/opt/dell/srvadmin/bin/omconfig storage controller action=exportlog controller=$ControllerNumber >>$LOG_FILE  2>&1 &
            Timeout $! 5
			mv -f /var/log/afa_$timeDate* "$RAIDCONTROLLER/Controller_$ControllerNumber.txt" 2>>$LOG_FILE
			mv -f /var/log/lsi_$timeDate* "$RAIDCONTROLLER/Controller_$ControllerNumber.txt" 2>>$LOG_FILE
            let "ControllerNumber += 1"
			# Gather any controller logs found
		
		done
	fi
	# GATHERING OMSS Logs finished. 
	
	
}
 '


getSystemConfiguration() {
	echo ${TEE2LOG}
if [ -f /etc/os-release ];then
	. /etc/os-release
fi

	echo "* Getting Linux operating system configuration information ..." ${TEE2LOG}
	#Dell: Is this OVM
    catiffile "/etc/ovs-release"
    catiffile "/etc/oracle-release"
	
	#STATUS="Determining Red Hat Linux version:"
	catiffile "/etc/redhat-release"
#Dell: Is this SuSE?
if [ "$ID" = "sles" ]; then
    if [ -f /etc/SuSE-release ];then
        catiffile "/etc/SuSE-release"
    else
        cat /etc/os-release|grep PRETTY_NAME|cut -d=  -f2|sed -e 's/^"//' -e 's/"$//' >/etc/SuSE-release
        catiffile "/etc/SuSE-release"
        rm -f /etc/SuSE-release
    fi 
fi

	#Dell: Is this Vmware
	catiffile "/etc/vmware-release"

	#Dell: Regardless, get the right OS name for GUI
	echo $LINUX_VERSION > $ROOT/osversion
	
	#STATUS="Determinding your current hostname: " 
	catifexec "/bin/hostname"
	#STATUS="Getting the date:"
	catifexec "/bin/date"
	#STATUS="Checking your systems current uptime and load average:"
	catifexec "/usr/bin/uptime"
	#STATUS="Checking available memory:"
	catifexec "/usr/bin/free"
	#STATUS="Checking free disk space:"
	catifexec "/bin/df" "-al"
	#STATUS="Checking currently running processes:"
	catifexec "/bin/ps" "auxww"
	#STATUS="Checking current process tree:"
	catifexec "/usr/bin/pstree"
	#STATUS="Collecting information about ld.so:"
	catiffile "/etc/ld.so.conf"
	# Storing dmesg location on DMESG variable 
	DMESG=`which dmesg`

	#Dell: Also get the ldconfig list
	/sbin/ldconfig -p > $ROOT/ldconfig
	
	SAMBADIR="/etc/samba"
	if [ -d $SAMBADIR ]; then
	  #STATUS="Getting samba informations ($SAMBADIR)"
	  for x in `/bin/ls -d $SAMBADIR/* | grep -vE 'smbpasswd|secrets\.tdb|\.bak|\.rpmnew'` ; do
		catiffile "$x"
	  done
	  /bin/ls -alR $SAMBADIR > $ROOT/ls-samba 2>&1
	fi
	
	#STATUS="Collecting host resolution information"
	catiffile "/etc/resolv.conf"
	# Make sure we have support for both versions of bind
	if [ -f /etc/named.boot ]; then
	  #STATUS="Collecting information about the nameserver (named.boot)"
	  catiffile "/etc/named.boot"
	elif [ -f /etc/named.conf ]; then
	  #STATUS="Collecting information about the nameserver (named.conf)"
	  catiffile "/etc/named.conf"
	fi
	
	echo "     Gathering information from system logs ..." ${TEE2LOG}
	#STATUS="Collecting information from dmesg:"

	#SuSE doesn't record the kernel ring buffer so we have to call it manually
	if [ -e "/etc/SuSE-release" ]; then
			 mkdir -p $ROOT/var/log/
			 `dmesg | tail -1000 > $ROOT/var/log/dmesg`
	else
			 if [ -e "/var/log/dmesg" ]; then
				  mkdir -p $ROOT/var/log/
			  `/usr/bin/tail -1000 /var/log/dmesg > $ROOT/var/log/dmesg`
			 elif [ "$DMESG" ];  then
				  mkdir -p $ROOT/var/log/
			  `$DMESG | tail -1000 > $ROOT/var/log/dmesg`				  
			 fi
	fi


	#STATUS="Collecting messages and system accounting information"
	if [ -e "/var/log/messages" ]; then
		  mkdir -p $ROOT/var/log/
		  `/usr/bin/tail -1000 /var/log/messages > $ROOT/var/log/messages`
	elif [ -e "/var/log/syslog" ];  then
		 mkdir -p $ROOT/var/log/
		 `/usr/bin/tail -1000 /var/log/syslog > $ROOT/var/log/messages`
	fi
	
	
	echo "     Gathering information on SELinux setup ..." ${TEE2LOG}

	catifexec "/usr/bin/selinuxconfig"
	catifexec "/usr/sbin/sestatus"
	catifexec "rpm" "-q -V selinux-policy-targeted"
	catifexec "rpm" "-q -V selinux-policy-strict"
	
	if [ -f /etc/os-release ];then
        . /etc/os-release
	fi

	if [ "$ID" !=  "ubuntu" ] && [ "$ID" !=  "debian" ]; then
	#gathering information on SELinux setup in root folder
	/bin/rpm -q -V selinux-policy-targeted >> $ROOT/selinux-policy-targeted
	/bin/rpm -q -V selinux-policy-strict >> $ROOT/selinux-policy-strict
	fi
}

checkRPM() {

if [ -f /etc/os-release ];then
        . /etc/os-release
fi

if [ "$ID" =  "ubuntu" ] || [ "$ID" =  "debian" ]; then

          echo "     Collecting information about currently installed packages ..." ${TEE2LOG}

        # Dell: We need more dpkg info than what Ubuntu/Debian wants !
        /usr/bin/dpkg-query -f '${Package}-${Version}\t =+= ${Architecture}\t =+= ${Installed-Size} bytes\t =+= ${Essential}\t =+= ${Maintainer}\t =+= ${binary:Summary}\n' -W  > $ROOT/installed-rpms

else

	# check to see if we want to run rpm, under some circumstances
	# rpm can hang and never complete
	# yes, command line parsing needs some work
	if [ ${1}s != "-norpms" ]; then
	  echo "     Collecting information about currently installed packages ..." ${TEE2LOG}
	#  /bin/rpm -qa > $ROOT/installed-rpms
	#  /bin/rpm -qa --qf "%{NAME}-%{VERSION}-%{RELEASE}-%{ARCH}\n" > $ROOT/installed-rpms

	# Dell: We need more RPM info than what Red Hat wants and we want it sorted!
	/bin/rpm -qa --queryformat '%{NAME}-%{VERSION}-%{RELEASE}\t =+= %{VENDOR}\t =+= %{SIZE} bytes\t =+= %{INSTALLTIME:day}\t =+= %{URL}\t =+= %{SUMMARY}\n' | /bin/sort > $ROOT/installed-rpms

	#  /bin/rpm -Va > $ROOT/rpm-Va
	fi
fi
}

getBOOTLoaderInfo() {
	echo "     Getting bootloader information ..." ${TEE2LOG}
	/bin/ls -alR /boot > $ROOT/ls-boot 2>&1
	# This covers sparc, alpha, and intel (respectively)
	# updated for grub -mpg
	if [ -f /etc/silo.conf ]; then
	  #STATUS="Collecting information about the boot process (silo):"
	  catiffile "/etc/silo.conf"
	fi
	if [ -f /etc/milo.conf ]; then
	  #STATUS="Collecting information about the boot process (milo):"
	  catiffile "/etc/milo.conf"
	fi
	if [ -f /etc/lilo.conf ]; then
	  #STATUS="Collecting information about the boot process (lilo):"
	  catiffile "/etc/lilo.conf"
	  catifexec "/sbin/lilo" "-q"
	fi

	if [ -f /boot/grub/menu.lst ]; then
	  # STATUS = "Collecting Boot menu Information"
	  catiffile "/boot/grub/menu.lst"
	fi
	#if [ -d /boot/grub -a -f /boot/grub/grub.conf -a -f /boot/grub/device.map ]; then
	if [ -d /boot/grub ]; then 
	  #STATUS="Collecting information about the boot process (grub):"
	  catiffile "/boot/grub/grub.conf"
	  catiffile "/boot/grub/device.map"
	fi
	if [ -f /etc/cluster.conf -o -f /etc/cluster.xml ] ; then
	  #STATUS="Gathering information on cluster setup"
	  # 2.1 AS
	  if [ -f /etc/cluster.conf ] ; then
		catiffile "/etc/cluster.conf"
	  fi
	  # Taroon
	  if [ -f /etc/cluster.xml ] ; then
		catiffile "/etc/cluster.xml"
	  fi
	fi
}

getXinfo() {
	STATUS="Collecting information about X:"

	# Dell: Trim down the X baggage
	#catiffile "/etc/X11"
	mkdir --parents "$ROOT/etc/X11" >> $DSETLOG
	echo > "$ROOT/etc/X11/XF86Config"
	if [ -f /etc/X11/XF86Config ]; then
		catiffile "/etc/X11/XF86Config"    
	else
		# new check needed for VMWare 3.x
		if [ -f /etc/X11/xorg.conf ]; then
			if [ -z `catiffile "/etc/X11/xorg.conf"` ]; then    
				/bin/mv -f -v "$ROOT/etc/X11/xorg.conf" "$ROOT/etc/X11/XF86Config" >> $DSETLOG
			fi
		elif  [ -f /root/xorg.conf.new ]; then
			if [ -z `catiffile "/etc/X11/xorg.conf"` ]; then
				/bin/cp -f -v "/root/xorg.conf.new" "$ROOT/etc/X11/XF86Config" >> $DSETLOG
			fi
        else
			filepath="$(pwd)"
			cd ~
			#cd /root
			if [ -f /etc/os-release ];then
			     . /etc/os-release
			fi
			
			VER=`echo $VERSION_ID | cut -d"." -f1`
			if [[ "$VER" ==  "12" && $ID == "sles" ]]; then
				#JIT-156367: will not run this command for SLES12 SPx
				echo "sles12 OS skipping Xorg properties" >> $DSETLOG
			else
				#for other OS's
				Xorg :1 -configure  > /dev/null 2>&1
			fi
			
			if [ -z `catiffile "/etc/X11/xorg.conf"` ]; then
				if [ -f /root/xorg.conf.new ]; then
					/bin/mv -f -v "/root/xorg.conf.new" "$ROOT/etc/X11/XF86Config" >> $DSETLOG
				fi
			fi
			#echo $filepath
			cd filepath >/dev/null 2>&1
		fi
	fi
}

getSystemControlandIP() {
	#STATUS="Gathering sysctl information:"
	catiffile "/proc/sys"
	catiffile "/etc/sysctl.conf"
	#STATUS="Collecting information about cron:"
	for x in `/bin/ls -d /etc/cron*` ; do
	  catiffile "$x"
	done
	#STATUS="Gathering IP information (/sbin/ifconfig):"
	catifexec "/sbin/ifconfig" "-a"
	#STATUS="Checking network routes:"
	catifexec "/sbin/route" "-n"
	#STATUS="Collecting system configuration information"
	catiffile "/etc/sysconfig"
	#STATUS="Collecting information about system authentication (pam)"
	catiffile "/etc/pam.d"
	
	if [ -f /etc/sysconfig/isdncard ] ; then
		#STATUS="Gathering information about ISDN:"
		catiffile "/etc/sysconfig/isdncard"
	fi
	
	echo "     Collecting information about commonly used network services ..." ${TEE2LOG}
	# This covers backwards compatiablity for systems with inetd while keeping 
	# support for the new 7.x xinetd
	if [ -f /etc/inetd.conf ]; then
	  #STATUS="Collecting information about system services (inetd.conf)"
	  catiffile "/etc/inetd.conf"
	elif [ -f /etc/xinetd.conf ]; then
	  #STATUS="Collecting information about system services (xinetd.conf)"
	  catiffile "/etc/xinetd.conf"
	  #STATUS="Collecting information about system services (xinetd.d)"
	  for x in `/bin/ls -d /etc/xinetd.d/*`; do
		catiffile "$x"
	  done
	fi
	#STATUS="Collecting information from /etc/host,host.allow, etc:"
	for x in `/bin/ls -d /etc/host*` ; do
	  catiffile "$x"
	done
	#ftpconfigfiles=`/bin/ls -d /etc/ftp* 2>>$LOG_FILE`  
	ftpconfigfiles=`/bin/ls -d /etc/ftp* /etc/vsftpd/* 2>>$LOG_FILE`  
	  #STATUS="Collecting information about the ftp servers:"
	  for x in $ftpconfigfiles; do
		#STATUS="Collecting information about the ftp servers:"
		catiffile "$x"
	done
	
	DNSDIR=""
	if [ -f /etc/named.conf ]; then
	  DNSDIR=$(/bin/grep -i directory /etc/named.conf |/bin/gawk '{ print $2 ;}'|\
		/bin/sed s/\"//g|/bin/sed s/\;//g)
	elif [ -f /etc/named.boot ]; then
	  DNSDIR=$(/bin/grep -i directory /etc/named.boot|/bin/gawk '{ print $2 ;}')
	fi
}

getKernelInfo() {

	echo "     Getting information about the kernel ..." ${TEE2LOG}

	#STATUS="Getting kernel version:"
	catifexec "/bin/uname" "-a"
	#STATUS="Checking module information:"
	catifexec "/sbin/lsmod"
	#STATUS="Currently getting ksysms information:"
	catifexec "/sbin/ksyms"
	#STATUS="Gathering information about your filesystems:"
	catiffile "/proc/filesystems"
	#STATUS="Gathering information about your system stat:"
	catiffile "/proc/stat"
	#STATUS="Gathering information about your partitions (/proc/partitions):"
	catiffile "/proc/partitions"
	#STATUS="Gathering information about your ksysms:"
	catiffile "/proc/ksyms"
	
	# dkms status
	#STATUS="Gathering current status of modules, versions and kernels (dkms):"
	if [ -x /usr/sbin/dkms ] ; then
	  catifexec "/usr/sbin/dkms" "status"
	fi
	
	KERNELMIN=`/bin/uname -r | /bin/sed -e 's,[^\.]*\.,,' -e 's,\..*,,'`
	ipchainsmod=`/sbin/lsmod | /bin/grep ipchains`

	if [ "$KERNELMIN" -lt 3 ] || [ -n $ipchainsmod ] ; then
	  #STATUS="Getting ipchains information:"
	  catifexec "/sbin/ipchains" "-nvL"
	elif [ "$KERNELMIN" -gt 3 ]; then
	  #STATUS="Getting iptables information:"
	  /bin/echo "<--iptables -t filter -nvL-->" > $ROOT/iptables
	  /sbin/iptables -t filter -nvL >> $ROOT/iptables
	  /bin/echo "<--iptables -t mangle -nvL-->" >> $ROOT/iptables
	  /sbin/iptables -t mangle -nvL >> $ROOT/iptables
	  /bin/echo "<--iptables -t nat -nvL-->" >> $ROOT/iptables
	  /sbin/iptables -t nat -nvL >> $ROOT/iptables
	#  echo_success
	fi
}

getRaidControllerInfo() {
	#STATUS="Gathering information about Dell RAID controllers:"
	catiffile "/proc/megaraid"
	catiffile "/proc/scsi/aacraid"
	catiffile "/proc/scsi/aic7xxx"

	# Added support to cover for the new modules.conf layout in Red Hat 7
	# Added support for modprobe.conf in RHEL4
	echo "     Collecting information regarding kernel modules ..." ${TEE2LOG}

	# Dell: Do this manually so we dont throw off GUI with the directory variation

	/bin/mkdir --parents "$ROOT/lib/modules/current"
	/bin/cp -f "/lib/modules/$VER/modules.dep" "$ROOT/lib/modules/current"


	#catiffile "/lib/modules/$VER/modules.dep"

	if [ -f /etc/conf.modules ]; then
	  catiffile "/etc/conf.modules"
	elif [ -f /etc/modules.conf ]; then
	  catiffile "/etc/modules.conf"
	elif [ -f /etc/modprobe.conf ]; then
	  catiffile "/etc/modprobe.conf"
	fi

}

getHardwareInfo() {
	echo "     Getting information about the hardware ..." ${TEE2LOG}
	if [ -x /usr/sbin/dmidecode ] ; then
	  #STATUS="Gathering DMI information:"
	  catifexec "/usr/sbin/dmidecode"
	  if [ "$?" == "0" ]; then
			echo "Call to catifexec for /usr/sbin/dmidecode failed" >> $DSETLOG
		echo "So calling our dmidecode" >> $DSETLOG
			DMIDECODE=`find ./ -name dmidecode`
			catifexec "${DMIDECODE}"
	  fi
	fi
	
	echo "     Getting disk and filesystem information ..." ${TEE2LOG}
	#STATUS="Collecting information from /etc/fstab:"
	catiffile "/etc/fstab"
	#STATUS="Collecting disk partition information:"
	#PATH=/bin
	getpartinfo > $ROOT/fdisk-l
	#STATUS="Checking mounted file systems:"
	catifexec "/bin/mount"
	catiffile "/proc/mounts"
	#STATUS="Collecting Software RAID information:"
	catiffile "/proc/mdstat"
	catiffile "/etc/raidtab"
}

collectPROCdir() {

	echo "     Collecting information from the proc directory ..." ${TEE2LOG}

	catiffile "/proc/pci"
	#STATUS="Getting kernel command line"
	catiffile "/proc/cmdline"
	#STATUS="Gathering information about your CPU:"
	catiffile "/proc/cpuinfo"
	#STATUS="Gathering information about your Ram:"
	catiffile "/proc/meminfo"
	#STATUS="Gathering information about your ioports:"
	catiffile "/proc/ioports"
	#STATUS="Gathering information about your interrupts:"
	catiffile "/proc/interrupts"
	#STATUS="Gathering information about your scsi devices:"
	catiffile "/proc/scsi"
	#STATUS="Gathering information about your dma:"
	catiffile "/proc/dma"
	#STATUS="Gathering information about your devices (/proc/devices):"
	catiffile "/proc/devices"
	#STATUS="Gathering information about your rtc:"
	catiffile "/proc/rtc"
	#STATUS="Gathering information about your ide drivers:"
	catiffile "/proc/ide"
	#STATUS="Gathering information about your bus:"
	getpciinfo > $ROOT/lspci
	#STATUS="Gathering information about iptables:"
	iptablesPath=`which iptables`
	getiptableinfo $iptablesPath > $ROOT/iptables
	catiffile "/proc/bus"
	#SuSE doesn't list the usb devices in proc/bus/usb it is in dev/bus/usb
	## check if SuSe then use lsusb to get device info
	#Find the location of the executable lsusb
	execPath=`which lsusb 2>&1`
	if [ $? == 0 ]; then
		#found lsusb executable
		${execPath} -v > $ROOT/proc/bus/usb/devices
	   else
		#lsusb not found
		echo "No USB devices found." >> $ROOT/proc/bus/usb/devices
	fi

	#Dell: Requested by IPS
	catiffile "/proc/slabinfo"
	
}

sendMail() {
	#sendmail
	SENDMAIL_CF_FILE=/etc/mail/sendmail.cf
	SENDMAIL_CW_FILE=/etc/mail/sendmail.cw

	if [ -f /etc/sendmail.cf ] ; then
	   SENDMAIL_CF_FILE=/etc/sendmail.cf
	fi

	if [ -f /etc/sendmail.cw ] ; then
	   SENDMAIL_CW_FILE=/etc/sendmail.cw
	fi

	#STATUS="Sendmail Configuration ($SENDMAIL_CF_FILE):"
	catiffile "$SENDMAIL_CF_FILE"
	if [ -f $SENDMAIL_CW_FILE ]; then
	  #STATUS="Sendmail Machine aliases ($SENDMAIL_CW_FILE):"
	  catiffile "$SENDMAIL_CW_FILE"
	fi

	#STATUS="Sendmail User aliases (/etc/aliases):"
	catiffile "/etc/aliases"

	#Dell: Don't get this. Sensitive
	##STATUS="Getting files from /etc/mail"
	#for f in `/bin/ls -d /etc/mail/* | /bin/grep -v \.db`; do
	#  catiffile $f
	#done
}

getEnvironment() {
#Dell: Extra OS stuff we want

echo "     Getting status of services ..." ${TEE2LOG}

#Dell: SuSE doesn't have a "service status" method so do it the manual way
#catifexec "/sbin/service" "--status-all"

rm -f $ROOT/service >>$LOG_FILE 2>&1

#Checking the systemd service

SYSTEMD=`cat /proc/1/comm`

if [ "$SYSTEMD" = "systemd" ] && [ -f /bin/sed ] && [ -f /bin/systemctl ];then
   	
SERVICELIST=`/bin/systemctl list-units --type=service |/bin/sed -e 's/^[ \t]*//'|cut -d " "  -f1 --output-delimiter=","|/bin/grep .service`

for SERVICE in $SERVICELIST
do
SERSTATUS=`/bin/systemctl list-units --type=service|/bin/grep $SERVICE|/bin/sed -e 's/^[ \t]*//'|cut -d " "  -f2-|/bin/sed -e 's/^[ \t]*//'`

echo "ValidXMLService ${SERVICE},${SERSTATUS} " >>$ROOT/service
echo >> $ROOT/service
echo "---------------------------------------------------------------------------" >> $ROOT/service
done
else
SERVICEDIR=/etc/init.d

	#pushd ${SERVICEDIR} >>$LOG_FILE
    for SERVICE in `ls -1 ${SERVICEDIR}` ; do
    case "${SERVICE}" in

	#Skip over these "services" since they tend to hang some systems when requested for status
	#changes done to support debian / ubuntu OS
    functions | halt | killall | single| linuxconf| kudzu | bgpd | boot | reboot | single | nscd | \
                  halt.* | rc* | boot.* | *rpmorig | *rpmnew | *rpmsave | *~ | *.orig)
 		  ;;
              *)
    if [ -x "${SERVICEDIR}/${SERVICE}" -a -f "${SERVICEDIR}/${SERVICE}" ]; then
	#echo "ValidXMLService ${SERVICE}," >> $ROOT/service
	#/usr/bin/env -i LANG=$LANG PATH=$PATH TERM=$TERM "${SERVICEDIR}/${SERVICE}" status 
	#/usr/bin/env -i LANG=$LANG PATH=$PATH TERM=$TERM "${SERVICEDIR}/${SERVICE}" status >> $ROOT/service 2>&1
		SERSTATUS=`/usr/bin/env -i LANG=${LANG} PATH=${PATH} TERM=${TERM} "${SERVICEDIR}/${SERVICE}" status`
		#echo $SERSTATUS
		echo "ValidXMLService ${SERVICE},${SERSTATUS} " >>$ROOT/service  
		echo >> $ROOT/service
		echo "---------------------------------------------------------------------------" >> $ROOT/service
    fi
        ;;
    esac
    done
fi
	#popd >>$LOG_FILE

	#STATUS="Getting environment variables:"
	printenv | sort > $ROOT/printenv
}

getdsetBootinfo() {
	# First misc. boot info for "Boot"

	echo > $ROOT/dsetboot

	if [ -f $ROOT/boot/grub/grub.conf ] ; then
			echo "boot/grub/grub.conf" >> $ROOT/dsetboot
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetboot
			cat $ROOT/boot/grub/grub.conf >> $ROOT/dsetboot
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetboot
	fi
	if [ -f $ROOT/boot/grub/menu.lst ] ; then
			echo "boot/grub/menu.lst" >> $ROOT/dsetboot
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetboot
			cat $ROOT/boot/grub/menu.lst >> $ROOT/dsetboot
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetboot
	fi
	if [ -f $ROOT/boot/grub/device.map ] ; then
			echo "boot/grub/device.map" >> $ROOT/dsetboot
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetboot
			cat $ROOT/boot/grub/device.map >> $ROOT/dsetboot
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetboot
	fi

	if [ -f $ROOT/etc/lilo.conf ] ; then
			echo "etc/lilo.conf" >> $ROOT/dsetboot
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetboot
			cat $ROOT/etc/lilo.conf >> $ROOT/dsetboot
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetboot
	fi

	if [ -f $ROOT/etc/milo.conf ] ; then
			echo "etc/milo.conf" >> $ROOT/dsetboot
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetboot
			cat $ROOT/etc/milo.conf >> $ROOT/dsetboot
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetboot
	fi


	if [ -f $ROOT/ls-boot ] ; then
			echo "ls-boot" >> $ROOT/dsetboot
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetboot
			cat $ROOT/ls-boot >> $ROOT/dsetboot
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetboot
	fi
}

getdsetModules() {
        
	# Now combine /etc/modules.conf with /lib/modules/modules.dep for "Modules"

	#echo > $ROOT/dsetmodules

	if [ -f $ROOT/lsmod ] ; then
			echo "lsmod" >> $ROOT/dsetmodules
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetmodules
			cat $ROOT/lsmod >> $ROOT/dsetmodules
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetmodules
	fi      
	if [ -f $ROOT/etc/modules.conf ] ; then
			echo "etc/modules.conf" >> $ROOT/dsetmodules
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetmodules
			cat $ROOT/etc/modules.conf >> $ROOT/dsetmodules
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetmodules
	fi

	if [ -f $ROOT/etc/modprobe.conf ] ; then
			echo "etc/modprobe.conf" >> $ROOT/dsetmodules
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetmodules
			cat $ROOT/etc/modprobe.conf >> $ROOT/dsetmodules
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetmodules
	fi

	if [ -f $ROOT/etc/conf.modules ] ; then
			echo "etc/conf.modules" >> $ROOT/dsetmodules
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetmodules
			cat $ROOT/etc/conf.modules >> $ROOT/dsetmodules
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetmodules
	fi
	#        echo >> $ROOT/dsetmodules

	if [ -f $ROOT/lib/modules/current/modules.dep ] ; then
			echo "lib/modules/$VER/modules.dep" >> $ROOT/dsetmodules
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetmodules
			cat $ROOT/lib/modules/current/modules.dep >> $ROOT/dsetmodules
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetmodules
	fi
}


getdsetMemoryInfo() {
	# Combine uptime with /proc/meminfo for "Memory"

	#echo > $ROOT/dsetmemory

	if [ -f $ROOT/uptime ] ; then
			echo "uptime" >> $ROOT/dsetmemory
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetmemory
			cat $ROOT/uptime >> $ROOT/dsetmemory
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetmemory
	fi
	if [ -f $ROOT/proc/meminfo ] ; then
			echo "/proc/meminfo" >> $ROOT/dsetmemory
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetmemory
			cat $ROOT/proc/meminfo >> $ROOT/dsetmemory
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetmemory
	fi
}

getdsetStorageInfo() {
	# Combine df with /proc/scsi and /proc/ide for "Storage Devices"


	if [ -f $ROOT/free ] ; then
			echo "free" >> $ROOT/dsetstorage
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetstorage
			cat $ROOT/free >> $ROOT/dsetstorage
	fi

	if [ -f $ROOT/df ]; then
			cat $ROOT/df >>$ROOT/dsetstorage
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetstorage


	fi
	if [ -f $ROOT/proc/scsi/scsi ] ; then
			echo "proc/scsi/scsi" >> $ROOT/dsetstorage
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetstorage
			cat $ROOT/proc/scsi/scsi >> $ROOT/dsetstorage
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetstorage
	fi

	if [ -f $ROOT/proc/scsi/usb-storage/1 ] ; then
			echo "proc/scsi/usb-storage" >> $ROOT/dsetstorage
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetstorage
			echo >> $ROOT/dsetstorage
		for x in `/bin/ls -d $ROOT/proc/scsi/usb-storage/*` ; do
				cat "$x" >> $ROOT/dsetstorage
				echo >> $ROOT/dsetstorage
		done
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetstorage
	#        echo >> $ROOT/dsetstorage
	fi

}


getdsetNWInfo() {
	#Combine a bunch of items for "Network Devices"

	#echo > $ROOT/dsetnetwork

	if [ -f $ROOT/ifconfig ] ; then
			echo "ifconfig" >> $ROOT/dsetnetwork
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetnetwork
			cat $ROOT/ifconfig >> $ROOT/dsetnetwork
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetnetwork
	fi

	if [ -f $ROOT/etc/resolv.conf ] ; then
			echo "etc/resolv.conf" >> $ROOT/dsetnetwork
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetnetwork
			cat $ROOT/etc/resolv.conf >> $ROOT/dsetnetwork
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetnetwork
	fi

	# A loop to find and list all current ifcfg-* files and append them

	if [ -f $ROOT/etc/hosts ] ; then
			echo "etc/hosts" >> $ROOT/dsetnetwork
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetnetwork
			cat $ROOT/etc/hosts >> $ROOT/dsetnetwork
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetnetwork
	fi

	# A loop to find and list all current ifcfg-* files and append them

	ls $ROOT/etc/sysconfig/network-scripts/ifcfg-*
	if [ $? -eq 0 ] ; then

	#TODO: Get rid of the data/linux prefix

			for files in `ls -1 $ROOT/etc/sysconfig/network-scripts/ifcfg-*`
			do
					NETFILEPATH=${files#$ROOT}
					echo "Network device configuration ($NETFILEPATH)" >> $ROOT/dsetnetwork
					echo "----------------------------------------------------------------------------" >> $ROOT/dsetnetwork
					cat $files >> $ROOT/dsetnetwork
					echo >> $ROOT/dsetnetwork
					echo >> $ROOT/dsetnetwork
					echo >> $ROOT/dsetnetwork
			done
	fi
	
	mkdir -p $NETSTAT
	`/bin/netstat -r >> $NETSTAT/netstatinfo.txt`
	`/bin/netstat -s >> $NETSTAT/netstatinfo.txt`
	`/bin/netstat -ao >> $NETSTAT/netstatinfo.txt`
}

getSoftwareSummary () {
	# Now create a summary page of Red Hat dist info, kernel, and mount info
	
	if [ -f $ROOT/etc/ovs-release ] ; then
		 echo osversion >> $ROOT/softsummary
		 echo ---------------------------------------------------------------------------- >> $ROOT/softsummary
		 cat $ROOT/etc/ovs-release >> $ROOT/softsummary
		 echo ---------------------------------------------------------------------------- >> $ROOT/softsummary
	elif [ -f $ROOT/etc/oracle-release ] ; then
		 echo osversion >> $ROOT/softsummary
		 echo ---------------------------------------------------------------------------- >> $ROOT/softsummary
		 cat $ROOT/etc/oracle-release >> $ROOT/softsummary
		 echo ---------------------------------------------------------------------------- >> $ROOT/softsummary
	else
	
	if [ -f $ROOT/etc/redhat-release ] ; then

		   if [ -f $ROOT/etc/vmware-release ] ; then
				  echo osversion >> $ROOT/softsummary
				  echo ---------------------------------------------------------------------------- >> $ROOT/softsummary
				  ESX_VERSION=`vmware -l`
				  echo $ESX_VERSION >> $ROOT/softsummary
				  echo ---------------------------------------------------------------------------- >> $ROOT/softsummary
		   else
			   echo osversion >> $ROOT/softsummary
			   echo ---------------------------------------------------------------------------- >> $ROOT/softsummary
			   cat $ROOT/etc/redhat-release >> $ROOT/softsummary
			   echo ---------------------------------------------------------------------------- >> $ROOT/softsummary
		   fi
		   
	fi
	fi

	if [ -f $ROOT/etc/SuSE-release ] ; then
		   echo osversion >> $ROOT/softsummary
		   echo ---------------------------------------------------------------------------- >> $ROOT/softsummary
		   cat $ROOT/etc/SuSE-release >> $ROOT/softsummary
		   echo ---------------------------------------------------------------------------- >> $ROOT/softsummary
	fi

	echo uname >> $ROOT/softsummary
	echo ---------------------------------------------------------------------------- >> $ROOT/softsummary
	if [ -e "$ROOT/uname" ]; then
		cat "$ROOT/uname" >> $ROOT/softsummary
	fi
	echo ---------------------------------------------------------------------------- >> $ROOT/softsummary
	echo proc/mounts >> $ROOT/softsummary
	echo ---------------------------------------------------------------------------- >> $ROOT/softsummary
	if [ -e "$ROOT/proc/mounts" ]; then
		cat "$ROOT/proc/mounts" >> $ROOT/softsummary
	fi
	echo ---------------------------------------------------------------------------- >> $ROOT/softsummary


	#Dell: If we're VMware then see if vm-support is present, and run it

	if [[ "$LINUX_NAME" = "vmware" || -e "/usr/bin/vmware" && -e "/usr/bin/vm-support" ]]; then
		echo "NOTE: VMware support tool detected. Collecting data ..." ${TEE2LOG}
		pushd $HOME >>$LOG_FILE
		#/usr/bin/vm-support >>$LOG_FILE 2>&1
		popd >>$LOG_FILE
		ESXFILE=`ls -1 -t $HOME/esx* | /usr/bin/head -n1`
		mkdir --parents $ROOT/VMWare
		echo "Moving VMWare support file to $ROOT/VMWare"
		#/bin/mv $ESXFILE $ROOT/VMWare
	fi
	echo install-date >> $ROOT/softsummary
	echo ---------------------------------------------------------------------------- >> $ROOT/softsummary
	echo `rpm -qi filesystem | grep -I 'Install Date'` >> $ROOT/softsummary
	echo ---------------------------------------------------------------------------- >> $ROOT/softsummary
	
	if [ -f /etc/os-release ];then
        . /etc/os-release
	fi

	if [ "$ID" !=  "ubuntu" ] && [ "$ID" !=  "debian" ]; then
	# getting install-date information in $ROOT/install-date
	/bin/rpm -qi filesystem | grep -I 'Install Date' >> $ROOT/install-date
	fi
}

checkOMSA(){

	Line="OpenManage Server Administrator is not installed"
	if [ ! -f  /etc/omreg.cfg ]
	then
		echo "Omsa Not Found"
		echo $Line >$ROOT/omsa

	else 
	Line=`cat /etc/omreg.cfg |grep openmanage.omacore.installpath`
	InstallPath=`echo $Line | awk -F"=" '{print $2}'`
	Line=`cat /etc/omreg.cfg |grep openmanage.version`
	Version=`echo $Line | awk -F"=" '{print $2}'`
	echo "Dell OpenManage Server Administrator (OMSA) is installed, "  $Version > $ROOT/omsa
	echo "Path: " $InstallPath >> $ROOT/omsa
	echo "The following OMSA services are installed:" >>$ROOT/omsa
	InstalledRPMs=`rpm -qa | grep 'srvadmin-\|instsvc-'`
	for item in ${InstalledRPMs}
		do
		Data=`rpm -q --queryformat '      %{SUMMARY}\n' $item`
		echo $Data >> $ROOT/omsa
		done

	fi
}

export LOG_FILE=/dev/null
#export LOG_FILE=/tmp/dset-sw.log 
#Script exection start point
readConfig

ORIG_PATH=$LD_LIBRARY_PATH
export LD_LIBRARY_PATH=

#ROOT points to where the files should be copied to. In DSET's case to ../data/linux/...
ROOT=$REPORTPATH/data/linux
DELLROOT=$REPORTPATH/data/dell
UTILDIR=.
VER=`/bin/uname -r`

#if [ $UID != 0 ]; then
#  echo "You must be root to use this utility"
#  exit 1
#fi

rm -rf $ROOT >>$LOG_FILE 2>&1
mkdir -p $ROOT >>$LOG_FILE 2>&1

rm -rf $DELLROOT >>$LOG_FILE 2>&1
mkdir -p $DELLROOT >>$LOG_FILE 2>&1

# Test for tee utility. If not exist, don't use it

if [ -e /usr/bin/tee ]; then
	TEE2LOG=""
else
	TEE2LOG=""
fi

# OMSA / OMI / DUP / SUU/ Diagnostics Logs Collection
OMSAROOT=$DELLROOT/OM_Server_Administrator
OMIROOT=$DELLROOT/OM_Installation
SUUROOT=$DELLROOT/Server_Update_Utility
DUPROOT=$DELLROOT/Dell_Update_Pkgs
NETSTAT=$DELLROOT/netstat
RAIDCONTROLLER=$DELLROOT/RAID\ Controllers
RACLOGS=$DELLROOT/Remote_Access_Controller

InstInstallLog=/var/tmp/iisvc.log
DengInstallLog=/var/tmp/ideng.log
DKSlog=/var/lib/dell/openmanage/hapi/drivers/dks/esm/dksbuild.log
DKSlog2="/var/log/dc*.log"
SUUlogs="/var/log/dell/suu/*"
DUPlogs="/var/log/dell/updatepackage/log/support/*"

# If skipping logs was specified, just exit

export OMSApath=`grep -i "openmanage.omacore.installpath" /etc/omreg.cfg | awk -F "=" '{print $2}'`
	
export OMSAversion=`grep -i "openmanage.version" /etc/omreg.cfg | awk -F "=" '{print $2}'`

export RAC=''

export SuppGeneration=''

mkdir -p $OMSAROOT $OMIROOT

OMSAsetup

getServerUpdate


getDiagnosticLogs
#Commented as per EHR-209
#getControllerInformation

getSystemConfiguration

checkRPM

getBOOTLoaderInfo

getXinfo

getSystemControlandIP

getKernelInfo

getRaidControllerInfo

getHardwareInfo

collectPROCdir

sendMail

getEnvironment

getdsetBootinfo

getdsetModules

getdsetMemoryInfo

getdsetStorageInfo

getdsetNWInfo

getSoftwareSummary

checkOMSA 

export LD_LIBRARY_PATH=$ORIG_PATH
