# dell-sysreport-bsd.sh

export PATH=$PATH:"/sbin:/usr/sbin:/bin:/usr/bin:/usr/X11R6/bin"


Timeout()
{
	pid=`ps -A|grep $1`
	if [ "$pid" != "" ]; then
		sleep $2
	fi
	pid=`ps -A|grep $1`
	if [ "$pid" != "" ]; then
		kill -9 $1
	fi
}
getpciinfo() {
( echo "pciconf -l"
  echo
  /usr/sbin/pciconf -l
  echo
  echo "pciconf -lB"
  echo
  /usr/sbin/pciconf -lB
  echo
  echo "pciconf -lb"
  echo
  /usr/sbin/pciconf -lb
  echo
  echo "pciconf -lc"
  echo
  /usr/sbin/pciconf -lc
  echo
  echo "pciconf -le"
  echo
  /usr/sbin/pciconf -le
  echo
  echo "pciconf -lv"
  echo
  /usr/sbin/pciconf -lv
  echo
  echo "pciconf -lV"
  echo
  /usr/sbin/pciconf -lV ) 2>&1
}

getusbinfo() {
( echo "usbconfig"
  echo
  /usr/sbin/usbconfig
  echo
  echo "usbconfig dump_all_desc"
  /usr/sbin/usbconfig dump_all_desc
  echo
  echo "usbconfig dump_device_desc"
  /usr/sbin/usbconfig dump_device_desc 
  echo
  echo "usbconfig dump_curr_config_desc"
  /usr/sbin/usbconfig dump_curr_config_desc 
  echo
  echo "usbconfig dump_curr_config_desc"
  /usr/sbin/usbconfig dump_all_config_desc ) 2>&1
}

catiffile() {
  if [ -d $1 ]; then
#Added --dereference to follow symlinks across filesystems even if DSET is installed on a central share
    if /bin/cp --parents -R --dereference $1 $ROOT >>$LOG_FILE 2>&1
    then
      return 1
    fi
  fi
  if [ -f $1 ]; then
    if /bin/cp --parents --dereference $1 $ROOT >>$LOG_FILE 2>&1
    then
      return 1
    fi
  fi
  return 0
}

catifexec() {
  if [ -x $1 ]; then
   if [ -f /bin/basename ]; then
    if $* > $ROOT/`/bin/basename $1` 2>&1; then
      return 1
    fi
   elif [ -f /usr/bin/basename ]; then
    if $* > $ROOT/`/usr/bin/basename $1` 2>&1; then
      return 1
    fi
   fi
  fi
  return 0
}

#reading system configuration and setting paths
readConfig() {
	if [ -z "$BOOTUP" ]; then
	  if [ -f /etc/sysconfig/init ]; then
		  . /etc/sysconfig/init
	  else
		# This all seem confusing? Look in /etc/sysconfig/init,
		# or in /usr/doc/initscripts-*/sysconfig.txt
		LOGLEVEL=1
	  fi
	fi
	echo $1
	if [ -z $REPORTPATH ]; then
	export REPORTPATH=/tmp/dset
	fi

	if [ -z $DSETLOG ]; then
		export DSETLOG=$REPORTPATH/log/DSET/main.log
	fi

	mkdir -p $REPORTPATH/log/DSET

	umask 0077

}



getSystemConfiguration() {
	echo ${TEE2LOG}

	echo "* Getting Linux operating system configuration information ..." ${TEE2LOG}
	#Dell: Is this OVM
    catiffile "/etc/ovs-release"
    catiffile "/etc/oracle-release"
	
	#STATUS="Determining Red Hat Linux version:"
	catiffile "/etc/redhat-release"

	#Dell: Is this SuSE?
	catiffile "/etc/SuSE-release"

	#Dell: Is this Vmware
	catiffile "/etc/vmware-release"

	#Dell: Regardless, get the right OS name for GUI
	uname -r > $ROOT/osversion
	mkdir -p $ROOT/etc
	
	#STATUS="Determinding your current hostname: " 
	catifexec "/bin/hostname"
	#STATUS="Getting the date:"
	catifexec "/bin/date"
	#STATUS="Checking your systems current uptime and load average:"
	catifexec "/usr/bin/uptime"
	#STATUS="Checking available memory:"
	sysctl hw | egrep 'hw.(phys|user|real)' > $ROOT/free
	#STATUS="Checking free disk space:"
	catifexec "/bin/df" "-al"
	#STATUS="Checking currently running processes:"
	catifexec "/bin/ps" "auxww"
	#STATUS="Checking current process tree:"
	catifexec "/usr/bin/pstree"
	#STATUS="Collecting information about ld.so:"
	catiffile "/etc/ld.so.conf"

	#Dell: Also get the ldconfig list
	/sbin/ldconfig -p > $ROOT/ldconfig
	
	SAMBADIR="/etc/samba"
	if [ -d $SAMBADIR ]; then
	  #STATUS="Getting samba informations ($SAMBADIR)"
	  for x in `/bin/ls -d $SAMBADIR/* | grep -vE 'smbpasswd|secrets\.tdb|\.bak|\.rpmnew'` ; do
		catiffile "$x"
	  done
	  /bin/ls -alR $SAMBADIR > $ROOT/ls-samba 2>&1
	fi
	
	#STATUS="Collecting host resolution information"
	catiffile "/etc/resolv.conf"
	# Make sure we have support for both versions of bind
	if [ -f /etc/named.boot ]; then
	  #STATUS="Collecting information about the nameserver (named.boot)"
	  catiffile "/etc/named.boot"
	elif [ -f /etc/named.conf ]; then
	  #STATUS="Collecting information about the nameserver (named.conf)"
	  catiffile "/etc/named.conf"
	fi
	
	echo "     Gathering information from system logs ..." ${TEE2LOG}
	#STATUS="Collecting information from dmesg:"

	 if [ -e "/var/log/dmesg" ]; then
	 	mkdir -p $ROOT/var/log/
		`/usr/bin/tail -1000 /var/log/dmesg > $ROOT/var/log/dmesg`
	 elif [ -e "/var/log/dmesg.today" ]; then
	 	mkdir -p $ROOT/var/log/
		`/usr/bin/tail -1000 /var/log/dmesg.today > $ROOT/var/log/dmesg`
	 fi


	#STATUS="Collecting messages and system accounting information"
	if [ -e "/var/log/messages" ]; then
		  mkdir -p $ROOT/var/log/
		  `/usr/bin/tail -1000 /var/log/messages > $ROOT/var/log/messages`
	elif [ -e "/var/log/syslog" ];  then
		 mkdir -p $ROOT/var/log/
		 `/usr/bin/tail -1000 /var/log/syslog > $ROOT/var/log/messages`
	fi
	
	

}

checkRPM() {
	`pkg info -af | sort > $ROOT/installed-pkgs`
}

getBOOTLoaderInfo() {
	echo "     Getting bootloader information ..." ${TEE2LOG}
	/bin/ls -alR /boot > $ROOT/ls-boot 2>&1
	
	if [ -f /boot/defaults/loader.conf ]; then
	  #STATUS="Collecting information about the boot process :"
	  catiffile "/boot/defaults/loader.conf"
	fi
}


getSystemControlandIP() {
	#STATUS="Gathering sysctl information:"
	catiffile "/proc/sys"
	catiffile "/etc/sysctl.conf"
	#STATUS="Collecting information about cron:"
	for x in `/bin/ls -d /etc/cron*` ; do
	  catiffile "$x"
	done
	#STATUS="Gathering IP information (/sbin/ifconfig):"
	catifexec "/sbin/ifconfig" "-a"
	#STATUS="Checking network routes:"
	catifexec "/usr/bin/netstat" "-rn"
	#STATUS="Collecting system configuration information"
	catiffile "/etc/sysconfig"
	#STATUS="Collecting information about system authentication (pam)"
	catiffile "/etc/pam.d"
	
	if [ -f /etc/sysconfig/isdncard ] ; then
		#STATUS="Gathering information about ISDN:"
		catiffile "/etc/sysconfig/isdncard"
	fi
	
	echo "     Collecting information about commonly used network services ..." ${TEE2LOG}
	# This covers backwards compatiablity for systems with inetd while keeping 
	# support for the new 7.x xinetd
	if [ -f /etc/inetd.conf ]; then
	  #STATUS="Collecting information about system services (inetd.conf)"
	  catiffile "/etc/inetd.conf"
	elif [ -f /etc/xinetd.conf ]; then
	  #STATUS="Collecting information about system services (xinetd.conf)"
	  catiffile "/etc/xinetd.conf"
	  #STATUS="Collecting information about system services (xinetd.d)"
	  for x in `/bin/ls -d /etc/xinetd.d/*`; do
		catiffile "$x"
	  done
	fi
	#STATUS="Collecting information from /etc/host,host.allow, etc:"
	for x in `/bin/ls -d /etc/host*` ; do
	  catiffile "$x"
	done
	#ftpconfigfiles=`/bin/ls -d /etc/ftp* 2>>$LOG_FILE`  
	ftpconfigfiles=`/bin/ls -d /etc/ftp* /etc/vsftpd/* 2>>$LOG_FILE`  
	  #STATUS="Collecting information about the ftp servers:"
	  for x in $ftpconfigfiles; do
		#STATUS="Collecting information about the ftp servers:"
		catiffile "$x"
	done
	
	DNSDIR=""
	if [ -f /etc/named.conf ]; then
	  DNSDIR=$(/bin/grep -i directory /etc/named.conf |/bin/gawk '{ print $2 ;}'|\
		/bin/sed s/\"//g|/bin/sed s/\;//g)
	elif [ -f /etc/named.boot ]; then
	  DNSDIR=$(/bin/grep -i directory /etc/named.boot|/bin/gawk '{ print $2 ;}')
	fi
}

getKernelInfo() {

	echo "     Getting information about the kernel ..." ${TEE2LOG}

	#STATUS="Getting kernel version:"
	catifexec "/bin/uname" "-a"
	#STATUS="Checking module information:"
	catifexec "/sbin/kldstat"
	
	
}


getHardwareInfo() {
	echo "     Getting information about the hardware ..." ${TEE2LOG}
	if [ -x /usr/sbin/dmidecode ] ; then
	  #STATUS="Gathering DMI information:"
	  catifexec "/usr/sbin/dmidecode"
	  if [ "$?" == "0" ]; then
			echo "Call to catifexec for /usr/sbin/dmidecode failed" >> $DSETLOG
		echo "So calling our dmidecode" >> $DSETLOG
			DMIDECODE=`find ./ -name dmidecode`
			catifexec "${DMIDECODE}"
	  fi
	fi
	
	echo "     Getting disk and filesystem information ..." ${TEE2LOG}
	#STATUS="Collecting information from /etc/fstab:"
	catiffile "/etc/fstab"
	echo "fdisk -s" > $ROOT/fdisk
	fdisk -s  >> $ROOT/fdisk
	echo "gpart show" >> $ROOT/fdisk
	gpart show >> $ROOT/fdisk
	catifexec "/bin/mount"
}

collectPROCdir() {

	echo "     Collecting information from the proc directory ..." ${TEE2LOG}

	catiffile "/proc/pci"
	#STATUS="Getting kernel command line"
	catiffile "/proc/cmdline"
	#STATUS="Gathering information about your CPU:"
	catiffile "/proc/cpuinfo"
	#STATUS="Gathering information about your Ram:"
	catiffile "/proc/meminfo"
	#STATUS="Gathering information about your ioports:"
	catiffile "/proc/ioports"
	#STATUS="Gathering information about your interrupts:"
	catiffile "/proc/interrupts"
	#STATUS="Gathering information about your scsi devices:"
	catiffile "/proc/scsi"
	#STATUS="Gathering information about your dma:"
	catiffile "/proc/dma"
	#STATUS="Gathering information about your devices (/proc/devices):"
	catiffile "/proc/devices"
	#STATUS="Gathering information about your rtc:"
	catiffile "/proc/rtc"
	#STATUS="Gathering information about your ide drivers:"
	catiffile "/proc/ide"
	#STATUS="Gathering information about your bus:"
	getpciinfo > $ROOT/lspci
	#STATUS="Gathering information about iptables:"
	getusbinfo > $ROOT/lsusb
	
}

sendMail() {
	#sendmail
	SENDMAIL_CF_FILE=/etc/mail/sendmail.cf
	SENDMAIL_CW_FILE=/etc/mail/sendmail.cw

	if [ -f /etc/sendmail.cf ] ; then
	   SENDMAIL_CF_FILE=/etc/sendmail.cf
	fi

	if [ -f /etc/sendmail.cw ] ; then
	   SENDMAIL_CW_FILE=/etc/sendmail.cw
	fi

	#STATUS="Sendmail Configuration ($SENDMAIL_CF_FILE):"
	catiffile "$SENDMAIL_CF_FILE"
	if [ -f $SENDMAIL_CW_FILE ]; then
	  #STATUS="Sendmail Machine aliases ($SENDMAIL_CW_FILE):"
	  catiffile "$SENDMAIL_CW_FILE"
	fi

	#STATUS="Sendmail User aliases (/etc/aliases):"
	catiffile "/etc/aliases"

	#Dell: Don't get this. Sensitive
	##STATUS="Getting files from /etc/mail"
	#for f in `/bin/ls -d /etc/mail/* | /bin/grep -v \.db`; do
	#  catiffile $f
	#done
}



getdsetMemoryInfo() {
	# Combine uptime with /proc/meminfo for "Memory"

	#echo > $ROOT/dsetmemory

	if [ -f $ROOT/uptime ] ; then
			echo "uptime" >> $ROOT/dsetmemory
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetmemory
			cat $ROOT/uptime >> $ROOT/dsetmemory
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetmemory
	fi
	if [ -f $ROOT/proc/meminfo ] ; then
			echo "/proc/meminfo" >> $ROOT/dsetmemory
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetmemory
			cat $ROOT/proc/meminfo >> $ROOT/dsetmemory
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetmemory
	fi
}

getdsetStorageInfo() {
	# Combine df with /proc/scsi and /proc/ide for "Storage Devices"


	if [ -f $ROOT/free ] ; then
			echo "free" >> $ROOT/dsetstorage
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetstorage
			cat $ROOT/free >> $ROOT/dsetstorage
	fi

	if [ -f $ROOT/df ]; then
			cat $ROOT/df >>$ROOT/dsetstorage
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetstorage


	fi
	if [ -f $ROOT/proc/scsi/scsi ] ; then
			echo "proc/scsi/scsi" >> $ROOT/dsetstorage
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetstorage
			cat $ROOT/proc/scsi/scsi >> $ROOT/dsetstorage
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetstorage
	fi

	if [ -f $ROOT/proc/scsi/usb-storage/1 ] ; then
			echo "proc/scsi/usb-storage" >> $ROOT/dsetstorage
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetstorage
			echo >> $ROOT/dsetstorage
		for x in `/bin/ls -d $ROOT/proc/scsi/usb-storage/*` ; do
				cat "$x" >> $ROOT/dsetstorage
				echo >> $ROOT/dsetstorage
		done
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetstorage
	#        echo >> $ROOT/dsetstorage
	fi

}


getdsetNWInfo() {
	#Combine a bunch of items for "Network Devices"

	#echo > $ROOT/dsetnetwork

	if [ -f $ROOT/ifconfig ] ; then
			echo "ifconfig" >> $ROOT/dsetnetwork
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetnetwork
			cat $ROOT/ifconfig >> $ROOT/dsetnetwork
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetnetwork
	fi

	if [ -f $ROOT/etc/resolv.conf ] ; then
			echo "etc/resolv.conf" >> $ROOT/dsetnetwork
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetnetwork
			cat $ROOT/etc/resolv.conf >> $ROOT/dsetnetwork
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetnetwork
	fi

	# A loop to find and list all current ifcfg-* files and append them

	if [ -f $ROOT/etc/hosts ] ; then
			echo "etc/hosts" >> $ROOT/dsetnetwork
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetnetwork
			cat $ROOT/etc/hosts >> $ROOT/dsetnetwork
			echo "----------------------------------------------------------------------------" >> $ROOT/dsetnetwork
	fi

	# A loop to find and list all current ifcfg-* files and append them

	ls $ROOT/etc/sysconfig/network-scripts/ifcfg-*
	if [ $? -eq 0 ] ; then

	#TODO: Get rid of the data/linux prefix

			for files in `ls -1 $ROOT/etc/sysconfig/network-scripts/ifcfg-*`
			do
					NETFILEPATH=${files#$ROOT}
					echo "Network device configuration ($NETFILEPATH)" >> $ROOT/dsetnetwork
					echo "----------------------------------------------------------------------------" >> $ROOT/dsetnetwork
					cat $files >> $ROOT/dsetnetwork
					echo >> $ROOT/dsetnetwork
					echo >> $ROOT/dsetnetwork
					echo >> $ROOT/dsetnetwork
			done
	fi
	
	mkdir -p $NETSTAT
	netstat -r >> $NETSTAT/netstatinfo.txt
	netstat -s >> $NETSTAT/netstatinfo.txt
	netstat -ao >> $NETSTAT/netstatinfo.txt
}

getSoftwareSummary () {

	echo uname >> $ROOT/softsummary
	echo ---------------------------------------------------------------------------- >> $ROOT/softsummary
	if [ -e "$ROOT/uname" ]; then
		cat "$ROOT/uname" >> $ROOT/softsummary
	fi
	echo ---------------------------------------------------------------------------- >> $ROOT/softsummary
	echo proc/mounts >> $ROOT/softsummary
	echo ---------------------------------------------------------------------------- >> $ROOT/softsummary
	if [ -e "$ROOT/proc/mounts" ]; then
		cat "$ROOT/proc/mounts" >> $ROOT/softsummary
	fi
	echo ---------------------------------------------------------------------------- >> $ROOT/softsummary


	echo pkg info -a >> $ROOT/softsummary
	echo ---------------------------------------------------------------------------- >> $ROOT/softsummary
	pkg info -a >> $ROOT/softsummary
	echo ---------------------------------------------------------------------------- >> $ROOT/softsummary
	
	# getting install-date information in $ROOT/install-date
	echo install-date >> $ROOT/softsummary
	ls -lT /boot/defaults/loader.conf | cut -d " " -f9-12 >> $ROOT/install-date
}


export LOG_FILE=/dev/null
#export LOG_FILE=/tmp/dset-sw.log 
#Script exection start point
readConfig

ORIG_PATH=$LD_LIBRARY_PATH
export LD_LIBRARY_PATH=

#ROOT points to where the files should be copied to. In DSET's case to ../data/linux/...
ROOT=$REPORTPATH/data/linux
DELLROOT=$REPORTPATH/data/dell
UTILDIR=.
VER=`/bin/uname -r`

#if [ $UID != 0 ]; then
#  echo "You must be root to use this utility"
#  exit 1
#fi

rm -rf $ROOT >>$LOG_FILE 2>&1
mkdir -p $ROOT >>$LOG_FILE 2>&1

rm -rf $DELLROOT >>$LOG_FILE 2>&1
mkdir -p $DELLROOT >>$LOG_FILE 2>&1

# Test for tee utility. If not exist, don't use it

if [ -e /usr/bin/tee ]; then
	TEE2LOG=""
else
	TEE2LOG=""
fi

NETSTAT=$DELLROOT/netstat

InstInstallLog=/var/tmp/iisvc.log
DengInstallLog=/var/tmp/ideng.log
DKSlog=/var/lib/dell/openmanage/hapi/drivers/dks/esm/dksbuild.log
DKSlog2="/var/log/dc*.log"
SUUlogs="/var/log/dell/suu/*"
DUPlogs="/var/log/dell/updatepackage/log/support/*"

# If skipping logs was specified, just exit


export SuppGeneration=''



getSystemConfiguration

checkRPM

getBOOTLoaderInfo


getSystemControlandIP

getKernelInfo


getHardwareInfo

collectPROCdir

sendMail




getdsetMemoryInfo

getdsetStorageInfo

getdsetNWInfo

getSoftwareSummary


export LD_LIBRARY_PATH=$ORIG_PATH
