#! /bin/bash

getGeneration(){

        Platform_11G=`dmidecode -t system | grep [RTM][1-9][1][05] | awk '{print $4}'`
        Platform_12G=`dmidecode -t system | grep [RTM][1-9][2][05] | awk '{print $4}'`

        if [ "$Platform_11G" != "" ];
        then
            echo "11G"  >>$LOG_FILE
            RAC=./idracadm
            SuppGeneration="yes"
        fi
        echo $Platform_11G  >>$LOG_FILE
        echo $Platform_12G  >>$LOG_FILE
        if [ "$Platform_12G" != "" ];
        then
            echo "12G"  >>$LOG_FILE
            RAC=./idracadm7
            SuppGeneration="yes"
        fi
}

getRAClogs(){
    cwd_ld=$LD_LIBRARY_PATH
    RAC=racadm
    wd_dsetrac=/opt/dell/advdiags/dset/bin/utils
    wd_omsarac=/opt/dell/srvadmin/bin/
    cwd=$PWD
	RACLOGS=$REPORTPATH/data/dell/Remote_Access_Controller
	echo Creating RACLOGS folder @ $RACLOGS >>$LOG_FILE
    mkdir -p $RACLOGS

    echo "In RAC logs....."  >>$LOG_FILE
    echo LD_LIBRARY_PATH:$LD_LIBRARY_PATH  >>$LOG_FILE
    Executable="OMSA"
    idracadmpresent=`rpm -qa | grep srvadmin-racadm`
    racadmpresent=`rpm -qa | grep srvadmin-idracadm`

    if [ "$idracadmpresent" == "" ] && [ "$racadmpresent" == "" ];
    then
        #echo "idracadmpresent"
        Executable="DSET"
    fi
    if [ "$Executable" == "DSET" ];
    then
        export LD_LIBRARY_PATH=/opt/dell/advdiags/dset/bin/utils
        echo "dset rac"  >>$LOG_FILE
        getGeneration
        cd $wd_dsetrac
    else
        #cd $wd_omsarac
        echo "omsa rac"  >>$LOG_FILE
	SuppGeneration="yes"
    fi

    echo RAC:$RAC  >>$LOG_FILE 
    echo SuppGeneration:$SuppGeneration  >>$LOG_FILE 
    echo LD_LIBRARY_PATH:$LD_LIBRARY_PATH  >>$LOG_FILE
    echo pwd:  >>$LOG_FILE
    pwd  >>$LOG_FILE
    if [ "$SuppGeneration" != '' ];
    then
	    OLDPATH=$PATH
		echo OLDPATH:$PATH>>$LOG_FILE
	    export PATH=$PATH:/opt/dell/srvadmin/bin:/opt/dell/srvadmin/sbin
		echo NEWPATH:$PATH>>$LOG_FILE
        echo Starting rac logs>>$LOG_FILE
        $RAC getraclog >> $RACLOGS/RAC_log.txt 
        echo getraclog>>$LOG_FILE
        $RAC gettracelog >> $RACLOGS/RAC_tracelog.txt
        echo gettracelog>>$LOG_FILE
        $RAC getsysinfo >> $RACLOGS/dracinfo.txt
        echo getsysinfo>>$LOG_FILE
        $RAC getssninfo >> $RACLOGS/dracinfo.txt
        echo getssninfo>>$LOG_FILE
        $RAC getniccfg >> $RACLOGS/dracinfo.txt
        $RAC getconfig -g cfgRemoteHosts >> $RACLOGS/dracinfo.txt
        echo cfgRemoteHosts>>$LOG_FILE
        $RAC getconfig -g cfgSessionManagement >> $RACLOGS/dracinfo.txt
        echo cfgSessionManagement>>$LOG_FILE
        $RAC getconfig -g cfgSerial >> $RACLOGS/dracinfo.txt
        echo cfgSerial>>$LOG_FILE
        $RAC getconfig -g cfgOobSnmp >> $RACLOGS/dracinfo.txt
        echo cfgOobSnmp>>$LOG_FILE
        $RAC getconfig -g cfgRacTuning >> $RACLOGS/dracinfo.txt
        echo cfgRacTuning>>$LOG_FILE
        $RAC getconfig -g ifcRacManagedNodeOs >> $RACLOGS/dracinfo.txt
        echo ifcRacManagedNodeOs>>$LOG_FILE
        $RAC getconfig -g cfgRacSecurity >> $RACLOGS/dracinfo.txt
        echo cfgRacSecurity>>$LOG_FILE
        $RAC getconfig -g cfgRacVirtual >> $RACLOGS/dracinfo.txt
        echo cfgRacVirtual>>$LOG_FILE
        $RAC getconfig -g cfgActiveDirectory >> $RACLOGS/dracinfo.txt
        echo cfgActiveDirectory>>$LOG_FILE
        $RAC getconfig -g cfgLanNetworking >> $RACLOGS/dracinfo.txt
        echo cfgLanNetworking>>$LOG_FILE
		PATH=$OLDPATH
		echo Reverting OLDPATH:$PATH>>$LOG_FILE
    fi
    cd $cwd
    export LD_LIBRARY_PATH=$cwd_ld
}

#sctipt Starts from here
export LOG_FILE=/dev/null
#export LOG_FILE=/tmp/dset-ad.log 
export PATH="/sbin:/usr/sbin:/bin:/usr/bin:/usr/X11R6/bin"

if [ -z $REPORTPATH ]; then
	export REPORTPATH=/tmp/dset
fi

if [ -z $DSETLOG ]; then
	export DSETLOG=$REPORTPATH/log/DSET/main.log
fi

mkdir -p $REPORTPATH/log/DSET


umask 0077

#ROOT points to where the files should be copied to. In DSET's case to ../data/linux/...
ROOT=$REPORTPATH/data/linux



#STATUS="Collecting information from dmesg:"

#SuSE doesn't record the kernel ring buffer so we have to call it manually
if [ -e "/etc/SuSE-release" ]; then
         mkdir -p $ROOT/var/log/
         `/bin/dmesg > $ROOT/var/log/dmesg`
else
         if [ -e "/var/log/dmesg" ]; then
              mkdir -p $ROOT/var/log/
	      ` cat /var/log/dmesg > $ROOT/var/log/dmesg`
         fi
fi


#STATUS="Collecting messages and system accounting information"
if [ -e "/var/log/messages" ]; then
      mkdir -p $ROOT/var/log/
      `cat /var/log/messages > $ROOT/var/log/messages_full`
	  `/usr/bin/tail -1000 /var/log/messages > $ROOT/var/log/messages`
fi

#commenting the RAC logs
#date >>$LOG_FILE
#getRAClogs
#date >>$LOG_FILE
